/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes;

import java.util.Map;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.BrewingCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.FillCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.FluidCauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.MixCauldronRecipe;
import knightminer.inspirations.library.util.ReflectionUtil;
import knightminer.inspirations.recipes.RecipesClientProxy;
import knightminer.inspirations.recipes.RecipesEvents;
import knightminer.inspirations.recipes.block.EnhancedCauldronBlock;
import knightminer.inspirations.recipes.block.SmashingAnvilBlock;
import knightminer.inspirations.recipes.item.MixedDyedBottleItem;
import knightminer.inspirations.recipes.item.SimpleDyedBottleItem;
import knightminer.inspirations.recipes.recipe.cauldron.ArmorClearingCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.ArmorDyeingCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.BannerClearingCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.DyeCauldronWater;
import knightminer.inspirations.recipes.recipe.cauldron.TippedArrowCauldronRecipe;
import knightminer.inspirations.recipes.recipe.cauldron.empty.ContainerEmptyCauldron;
import knightminer.inspirations.recipes.recipe.cauldron.empty.DyedBottleEmptyCauldron;
import knightminer.inspirations.recipes.recipe.cauldron.empty.PotionEmptyCauldron;
import knightminer.inspirations.recipes.recipe.cauldron.empty.SpongeEmptyCauldron;
import knightminer.inspirations.recipes.recipe.cauldron.fill.DyedBottleFillCauldron;
import knightminer.inspirations.recipes.recipe.cauldron.fill.FluidContainerFillCauldron;
import knightminer.inspirations.recipes.recipe.cauldron.fill.PotionFillCauldron;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;

@Pulse(id="InspirationsRecipes", description="Adds additional recipe types, including cauldrons and anvil smashing")
public class InspirationsRecipes
extends PulseBase {
    public static final String pulseID = "InspirationsRecipes";
    public static Object proxy = DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> new RecipesClientProxy());
    public static Block fullAnvil;
    public static Block chippedAnvil;
    public static Block damagedAnvil;
    public static EnhancedCauldronBlock cauldron;
    public static Item splashBottle;
    public static Item lingeringBottle;
    public static Map<DyeColor, SimpleDyedBottleItem> simpleDyedWaterBottle;
    public static MixedDyedBottleItem mixedDyedWaterBottle;
    public static Fluid mushroomStew;
    public static Fluid beetrootSoup;
    public static Fluid rabbitStew;
    public static Fluid milk;

    @SubscribeEvent
    public void preInit(FMLCommonSetupEvent event) {
        if (!Config.enableCauldronFluids() || Config.enableMilk()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (((Boolean)Config.enableAnvilSmashing.get()).booleanValue()) {
            fullAnvil = new SmashingAnvilBlock(Blocks.field_150467_bQ);
            chippedAnvil = new SmashingAnvilBlock(Blocks.field_196717_eY);
            damagedAnvil = new SmashingAnvilBlock(Blocks.field_196718_eZ);
            r.registerAll((IForgeRegistryEntry[])new Block[]{fullAnvil, chippedAnvil, damagedAnvil});
        }
        if (Config.enableExtendedCauldron()) {
            cauldron = (EnhancedCauldronBlock)this.register(r, (IForgeRegistryEntry)new EnhancedCauldronBlock(), Blocks.field_150383_bp.getRegistryName());
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        splashBottle = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78038_k), Config::enableCauldronPotions), "splash_bottle");
        lingeringBottle = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78038_k), Config::enableCauldronPotions), "lingering_bottle");
        for (DyeColor color : DyeColor.values()) {
            simpleDyedWaterBottle.put(color, this.registerItem((IForgeRegistry<Item>)r, new SimpleDyedBottleItem(color), color.func_176610_l() + "_dyed_bottle"));
        }
        mixedDyedWaterBottle = this.registerItem((IForgeRegistry<Item>)r, new MixedDyedBottleItem(), "mixed_dyed_bottle");
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent event) {
        InspirationsRegistry.registerAnvilBreaking(Material.field_151592_s);
        if (Config.enableCauldronRecipes()) {
            this.registerCauldronRecipes();
        }
        this.registerDispenserBehavior();
    }

    @SubscribeEvent
    public void postInit(InterModProcessEvent event) {
        MinecraftForge.EVENT_BUS.register(RecipesEvents.class);
        this.registerPostCauldronRecipes();
    }

    private void registerCauldronRecipes() {
        InspirationsRegistry.registerDefaultCauldron();
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((Block)Blocks.field_150432_aD), (Fluid)Fluids.field_204546_a, InspirationsRegistry.getCauldronMax(), ItemStack.field_190927_a, true, SoundEvents.field_187627_L));
        if (Config.canSpongeEmptyCauldron()) {
            InspirationsRegistry.addCauldronRecipe(SpongeEmptyCauldron.INSTANCE);
        }
        if (((Boolean)Config.cauldronObsidian.get()).booleanValue()) {
            MixCauldronRecipe recipe = Config.enableCauldronFluids() ? new MixCauldronRecipe((Fluid)Fluids.field_204547_b, (Fluid)Fluids.field_204546_a, new ItemStack((IItemProvider)Blocks.field_150343_Z)) : new MixCauldronRecipe((Fluid)Fluids.field_204546_a, (Fluid)Fluids.field_204547_b, new ItemStack((IItemProvider)Blocks.field_150343_Z));
            InspirationsRegistry.addCauldronRecipe(recipe);
        }
        if (!Config.enableExtendedCauldron()) {
            return;
        }
        InspirationsRegistry.addCauldronRecipe(new ArmorClearingCauldronRecipe(ArmorMaterial.LEATHER));
        InspirationsRegistry.addCauldronRecipe(BannerClearingCauldronRecipe.INSTANCE);
        ItemStack waterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b);
        InspirationsRegistry.addCauldronRecipe(new FluidCauldronRecipe(RecipeMatch.of((Item)Items.field_151069_bo), (Fluid)Fluids.field_204546_a, waterBottle, null, SoundEvents.field_187615_H));
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.ofNBT((ItemStack)waterBottle), (Fluid)Fluids.field_204546_a, 1, new ItemStack((IItemProvider)Items.field_151069_bo)));
        if (Config.enableCauldronDyeing()) {
            InspirationsRegistry.addCauldronRecipe(DyedBottleEmptyCauldron.INSTANCE);
            InspirationsRegistry.addCauldronRecipe(DyedBottleFillCauldron.INSTANCE);
            InspirationsRegistry.addCauldronRecipe(new ArmorDyeingCauldronRecipe(ArmorMaterial.LEATHER));
            for (DyeColor color : DyeColor.values()) {
                InspirationsRegistry.addCauldronRecipe(new DyeCauldronWater(color));
            }
        }
        if (Config.enableCauldronPotions()) {
            InspirationsRecipes.addPotionBottle(Items.field_151068_bn, new ItemStack((IItemProvider)Items.field_151069_bo), "bottles/normal");
            InspirationsRecipes.addPotionBottle(Items.field_185155_bH, new ItemStack((IItemProvider)splashBottle), "bottles/splash");
            InspirationsRecipes.addPotionBottle(Items.field_185156_bI, new ItemStack((IItemProvider)lingeringBottle), "bottles/lingering");
            if (Config.cauldronTipArrows()) {
                InspirationsRegistry.addCauldronRecipe(TippedArrowCauldronRecipe.INSTANCE);
            }
        }
        if (Config.enableCauldronFluids()) {
            InspirationsRegistry.addCauldronRecipe(ContainerEmptyCauldron.INSTANCE);
            InspirationsRecipes.addStewRecipes(new ItemStack((IItemProvider)Items.field_185165_cW), beetrootSoup, new ItemStack((IItemProvider)Items.field_185164_cV, 6));
        } else {
            InspirationsRegistry.addCauldronFluidItem(new ItemStack((IItemProvider)Items.field_151131_as), new ItemStack((IItemProvider)Items.field_151133_ar), (Fluid)Fluids.field_204546_a, 3);
        }
    }

    private void registerPostCauldronRecipes() {
        if (Config.enableCauldronBrewing()) {
            for (Object recipe : PotionBrewing.field_185213_a) {
                Potion input = (Potion)ReflectionUtil.getMixPredicateInput(recipe);
                Ingredient reagent = ReflectionUtil.getMixPredicateReagent(recipe);
                Potion output = (Potion)ReflectionUtil.getMixPredicateOutput(recipe);
                if (input == null || reagent == null || output == null) continue;
                InspirationsRegistry.addCauldronRecipe(new BrewingCauldronRecipe(input, reagent, output));
            }
            this.findRecipesFromBrewingRegistry();
        }
        if (Config.enableCauldronFluids()) {
            InspirationsRegistry.addCauldronRecipe(FluidContainerFillCauldron.INSTANCE);
        }
    }

    private static void addPotionBottle(Item potion, ItemStack bottle, String bottleTag) {
        InspirationsRegistry.addCauldronRecipe(new PotionFillCauldron(potion, bottle));
        InspirationsRegistry.addCauldronRecipe(new PotionEmptyCauldron(potion, (Tag<Item>)new ItemTags.Wrapper(new ResourceLocation("forge", bottleTag))));
    }

    private static void addStewRecipes(ItemStack stew, Fluid fluid, ItemStack ingredient) {
        InspirationsRegistry.addCauldronScaledTransformRecipe(ingredient, (Fluid)Fluids.field_204546_a, fluid, true);
        InspirationsRegistry.addCauldronRecipe(new FluidCauldronRecipe(RecipeMatch.of((Item)Items.field_151054_z), fluid, stew, null, SoundEvents.field_187615_H));
        InspirationsRegistry.addCauldronRecipe(new FillCauldronRecipe(RecipeMatch.of((ItemStack)stew), fluid, 1, new ItemStack((IItemProvider)Items.field_151054_z)));
    }

    private void findRecipesFromBrewingRegistry() {
        for (IBrewingRecipe irecipe : BrewingRecipeRegistry.getRecipes()) {
            if (!(irecipe instanceof BrewingRecipe)) continue;
            BrewingRecipe recipe = (BrewingRecipe)irecipe;
            Ingredient inputIngredient = recipe.getInput();
            ItemStack outputStack = recipe.getOutput();
            Ingredient ingredient = recipe.getIngredient();
            if (ingredient == null || inputIngredient == null || outputStack == null) continue;
            ItemStack inputStack = ItemStack.field_190927_a;
            for (ItemStack validInput : inputIngredient.func_193365_a()) {
                if (validInput.func_77973_b() != Items.field_151068_bn) continue;
                inputStack = validInput;
                break;
            }
            if (inputStack.func_190926_b() || outputStack.func_77973_b() != Items.field_151068_bn) continue;
            Potion input = PotionUtils.func_185191_c((ItemStack)inputStack);
            Potion output = PotionUtils.func_185191_c((ItemStack)outputStack);
            if (input == Potions.field_185229_a || output == Potions.field_185229_a) continue;
            InspirationsRegistry.addCauldronRecipe(new BrewingCauldronRecipe(input, ingredient, output));
        }
    }

    private void registerDispenserBehavior() {
    }
}

