/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.recipes.client.BoilingParticle;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.ModelProperty;

public class EnhancedCauldronBlock
extends CauldronBlock {
    public static final EnumProperty<CauldronContents> CONTENTS = EnumProperty.func_177709_a((String)"contents", CauldronContents.class);
    public static final IntegerProperty LEVEL_EXT = IntegerProperty.func_177719_a((String)"levels", (int)0, (int)4);
    public static final BooleanProperty BOILING = BooleanProperty.func_177716_a((String)"boiling");
    public static final ModelProperty<String> TEXTURE = new ModelProperty();

    public EnhancedCauldronBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150383_bp));
        BlockState state = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176591_a, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)BOILING, (Comparable)Boolean.valueOf(false))).func_206870_a(CONTENTS, (Comparable)((Object)CauldronContents.FLUID));
        if (Config.enableBiggerCauldron()) {
            state = (BlockState)state.func_206870_a((IProperty)LEVEL_EXT, (Comparable)Integer.valueOf(0));
        }
        this.func_180632_j(state);
        this.setRegistryName(Blocks.field_150383_bp.getRegistryName());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CauldronTileEntity();
    }

    public void func_176224_k(World world, @Nonnull BlockPos pos) {
        BlockState state;
        int level;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CauldronTileEntity && !((CauldronTileEntity)te).isWater()) {
            return;
        }
        if ((Config.fasterCauldronRain() || world.field_73012_v.nextInt(20) == 0) && world.func_180494_b(pos).func_180626_a(pos) >= 0.15f && (level = this.getLevel(state = world.func_180495_p(pos))) < (Config.enableBiggerCauldron() ? 4 : 3)) {
            this.func_176590_a(world, pos, state, level + 1);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        int newLevel;
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof CauldronTileEntity)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        int level = this.getLevel(state);
        float f = (float)pos.func_177956_o() + ((Config.enableBiggerCauldron() ? 2.5f : 5.5f) + (float)(3 * Math.max(level, 1))) / 16.0f;
        if (entity.func_174813_aQ().field_72338_b <= (double)f && level != (newLevel = ((CauldronTileEntity)te).onEntityCollide(entity, level, state))) {
            this.func_176590_a(world, pos, state, newLevel);
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c() && !isMoving) {
            TileEntity te;
            int level = this.getLevel(state);
            if (((Boolean)Config.dropCauldronContents.get()).booleanValue() && level > 0 && (te = world.func_175625_s(pos)) instanceof CauldronTileEntity) {
                ((CauldronTileEntity)te).onBreak(pos, level);
            }
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CONTENTS, BOILING, field_176591_a});
        if (Config.enableBiggerCauldron()) {
            builder.func_206894_a(new IProperty[]{LEVEL_EXT});
        }
    }

    @Deprecated
    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CauldronTileEntity) {
            state = (BlockState)state.func_206870_a(CONTENTS, (Comparable)((Object)((CauldronTileEntity)te).getContentType()));
        }
        return state;
    }

    public boolean func_220051_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, BlockRayTraceResult ray) {
        return true;
    }

    @Deprecated
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        EnhancedCauldronBlock.setBoiling(world, pos, state);
    }

    private static void setBoiling(World world, BlockPos pos, BlockState state) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BOILING, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(InspirationsRegistry.TAG_CAULDRON_FIRE))));
    }

    @Deprecated
    public void func_196265_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (!((Boolean)state.func_177229_b((IProperty)BOILING)).booleanValue()) {
            return;
        }
        int level = this.getLevel(state);
        if (level == 0) {
            return;
        }
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        for (int i = 0; i < 2; ++i) {
            double x = (double)pos.func_177958_n() + 0.1875 + (double)rand.nextFloat() * 0.625;
            double y = (double)pos.func_177956_o() + (Config.enableBiggerCauldron() ? 0.1875 : 0.375) + (double)level * 0.1875;
            double z = (double)pos.func_177952_p() + 0.1875 + (double)rand.nextFloat() * 0.625;
            manager.func_78873_a((Particle)new BoilingParticle(world, x, y, z, 0.0, 0.0, 0.0));
        }
    }

    public void func_176590_a(World worldIn, @Nonnull BlockPos pos, BlockState state, int level) {
        if (Config.enableBiggerCauldron()) {
            state = (BlockState)state.func_206870_a((IProperty)LEVEL_EXT, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)4)));
        }
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176591_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        worldIn.func_175666_e(pos, (Block)this);
    }

    public static int getCauldronLevel(BlockState state) {
        Block block = state.func_177230_c();
        if (state.func_177230_c() instanceof EnhancedCauldronBlock) {
            return ((EnhancedCauldronBlock)block).getLevel(state);
        }
        if (state.func_206869_a().contains(field_176591_a)) {
            return (Integer)state.func_177229_b((IProperty)field_176591_a);
        }
        return InspirationsRegistry.getCauldronMax();
    }

    public int getLevel(BlockState state) {
        if (Config.enableBiggerCauldron()) {
            return (Integer)state.func_177229_b((IProperty)LEVEL_EXT);
        }
        return (Integer)state.func_177229_b((IProperty)field_176591_a);
    }

    @Deprecated
    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return this.getLevel(state);
    }

    public static enum CauldronContents implements IStringSerializable
    {
        FLUID,
        DYE,
        POTION;

        private int meta = this.ordinal();

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }

        public static CauldronContents fromMeta(int meta) {
            if (meta > CauldronContents.values().length) {
                meta = 0;
            }
            return CauldronContents.values()[meta];
        }
    }
}

