/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.dispenser;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.block.EnhancedCauldronBlock;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DispenseCauldronRecipe
extends DefaultDispenseItemBehavior {
    private static final DefaultDispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    private IDispenseItemBehavior fallback;

    public DispenseCauldronRecipe(IDispenseItemBehavior fallback) {
        this.fallback = fallback;
    }

    @Nonnull
    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        int newLevel;
        if (!stack.func_77973_b().func_206844_a(InspirationsRegistry.TAG_DISP_CAULDRON_RECIPES)) {
            return this.fallback.dispense(source, stack);
        }
        Direction side = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(side);
        World world = source.func_197524_h();
        BlockState state = world.func_180495_p(pos);
        if (!InspirationsRegistry.isNormalCauldron(state)) {
            return this.fallback.dispense(source, stack);
        }
        CauldronTileEntity cauldron = null;
        ICauldronRecipe.CauldronState cauldronState = ICauldronRecipe.CauldronState.WATER;
        boolean boiling = false;
        Block block = state.func_177230_c();
        if (Config.enableExtendedCauldron() && block instanceof EnhancedCauldronBlock) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof CauldronTileEntity) {
                cauldron = (CauldronTileEntity)te;
                cauldronState = cauldron.getState();
                boiling = (Boolean)state.func_177229_b((IProperty)EnhancedCauldronBlock.BOILING);
            }
        } else {
            cauldronState = InspirationsRegistry.getCauldronState(state);
            boiling = InspirationsRegistry.isCauldronFire(world.func_180495_p(pos.func_177977_b()));
        }
        int level = EnhancedCauldronBlock.getCauldronLevel(state);
        ICauldronRecipe recipe = InspirationsRegistry.getCauldronResult(stack, boiling, level, cauldronState);
        if (recipe == null) {
            return DEFAULT.dispense(source, stack);
        }
        ICauldronRecipe.CauldronState newState = recipe.getState(stack, boiling, level, cauldronState);
        if (!Config.enableExtendedCauldron() && !ICauldronRecipe.CauldronState.WATER.matches(newState)) {
            return DEFAULT.dispense(source, stack);
        }
        SoundEvent sound = recipe.getSound(stack, boiling, level, cauldronState);
        if (sound != null) {
            world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, recipe.getVolume(sound), 1.0f);
        }
        if ((newLevel = recipe.getLevel(level)) != level || !cauldronState.matches(newState)) {
            if (newLevel == InspirationsRegistry.getCauldronMax() && InspirationsRegistry.isNormalCauldron(state) && InspirationsRegistry.hasFullCauldron(newState)) {
                world.func_175656_a(pos, InspirationsRegistry.getFullCauldron(newState));
                cauldron = null;
            } else {
                if (!(block instanceof CauldronBlock)) {
                    TileEntity te;
                    ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, pos, Blocks.field_150383_bp.func_176223_P(), newLevel);
                    if (Config.enableExtendedCauldron() && (te = world.func_175625_s(pos)) instanceof CauldronTileEntity) {
                        cauldron = (CauldronTileEntity)te;
                    }
                } else {
                    ((CauldronBlock)block).func_176590_a(world, pos, state, newLevel);
                }
                if (newLevel == 0) {
                    newState = ICauldronRecipe.CauldronState.WATER;
                }
            }
        }
        if (cauldron != null) {
            cauldron.setState(newState, true);
        }
        ItemStack result = recipe.getResult(stack, boiling, level, cauldronState);
        ItemStack container = recipe.getContainer(stack);
        int oldSize = stack.func_190916_E();
        ItemStack remainder = recipe.transformInput(stack.func_77946_l(), boiling, level, cauldronState);
        if (remainder.func_190926_b()) {
            if (container.func_190926_b()) {
                return result;
            }
            container.func_190920_e(container.func_190916_E() * oldSize);
            DispenseCauldronRecipe.dispenseItem(source, result);
            return container;
        }
        DispenseCauldronRecipe.dispenseItem(source, result);
        if (!container.func_190926_b()) {
            container.func_190920_e(container.func_190916_E() * (oldSize - remainder.func_190916_E()));
            DispenseCauldronRecipe.dispenseItem(source, container);
        }
        return remainder;
    }

    private static void dispenseItem(IBlockSource source, ItemStack stack) {
        if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(stack) < 0) {
            DEFAULT.dispense(source, stack);
        }
    }
}

