/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.library.recipe.cauldron.ISimpleCauldronRecipe;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class DyeCauldronWater
implements ISimpleCauldronRecipe {
    private DyeColor color;
    private Ingredient dye;

    public DyeCauldronWater(DyeColor color) {
        this.color = color;
        this.dye = Ingredient.func_199805_a((Tag)ItemTags.func_199903_a().func_199915_b(new ResourceLocation("forge", "dyes/" + color.func_176610_l())));
    }

    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level == 0 || stack.func_77973_b().func_206844_a(InspirationsRegistry.TAG_DYE_BOTTLES)) {
            return false;
        }
        return (state.isWater() || state.getColor() > -1) && this.dye.test(stack) && this.color.field_193351_w != state.getColor();
    }

    @Override
    public List<ItemStack> getInput() {
        return Arrays.stream(this.dye.func_193365_a()).filter(stack -> !stack.func_77973_b().func_206844_a(InspirationsRegistry.TAG_DYE_BOTTLES)).collect(Collectors.toList());
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        int newColor = this.color.field_193351_w;
        int color = state.getColor();
        color = color > -1 ? Util.combineColors(newColor, color, level) : newColor;
        return ICauldronRecipe.CauldronState.dye(color);
    }

    @Override
    public Object getState() {
        return this.color;
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return null;
    }
}

