/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron.fill;

import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.item.MixedDyedBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public enum DyedBottleFillCauldron implements ICauldronRecipe
{
    INSTANCE;


    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level == InspirationsRegistry.getCauldronMax()) {
            return false;
        }
        return (state.isWater() || state.getColor() > -1) && stack.func_77973_b().func_206844_a(InspirationsRegistry.TAG_DYE_BOTTLES);
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        int newColor = MixedDyedBottleItem.dyeFromBottle(stack);
        if (level == 0) {
            return ICauldronRecipe.CauldronState.dye(newColor);
        }
        int color = state.getColor();
        if (newColor == color) {
            return state;
        }
        if (color == -1) {
            color = 0x888888;
        }
        return ICauldronRecipe.CauldronState.dye(Util.combineColors(newColor, color, level));
    }

    @Override
    public int getLevel(int level) {
        return level + 1;
    }

    @Override
    public ItemStack getResult(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return stack.func_77973_b().getContainerItem(stack);
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return SoundEvents.field_191241_J;
    }

    @Override
    public ItemStack getContainer(ItemStack stack) {
        return ItemStack.field_190927_a;
    }
}

