/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe.cauldron.fill;

import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public enum FluidContainerFillCauldron implements ICauldronRecipe
{
    INSTANCE;


    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level == InspirationsRegistry.getCauldronMax() || level > 0 && state.getFluid() == null) {
            return false;
        }
        return (Boolean)FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            FluidStack fluidStack = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            return ICauldronRecipe.CauldronState.fluidValid(fluidStack) && (level == 0 || fluidStack.getFluid() == state.getFluid());
        }).orElse((Object)false);
    }

    @Override
    public ItemStack getResult(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return (ItemStack)FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l()).map(handler -> {
            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse((Object)ItemStack.field_190927_a);
    }

    @Override
    public int getLevel(int level) {
        return InspirationsRegistry.getCauldronMax();
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        Fluid fluid = (Fluid)FluidUtil.getFluidHandler((ItemStack)stack).map(h -> h.drain(1000, IFluidHandler.FluidAction.SIMULATE).getFluid()).orElse(null);
        if (fluid == null || fluid == state.getFluid()) {
            return state;
        }
        return ICauldronRecipe.CauldronState.fluid(fluid);
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return (SoundEvent)FluidUtil.getFluidHandler((ItemStack)stack).map(h -> {
            FluidStack fluid = h.drain(1000, IFluidHandler.FluidAction.SIMULATE);
            return fluid.getFluid().getAttributes().getFillSound(fluid);
        }).orElse((Object)SoundEvents.field_187630_M);
    }

    @Override
    public ItemStack getContainer(ItemStack stack) {
        return ItemStack.field_190927_a;
    }
}

