/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tank;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CauldronTank
implements IFluidHandler {
    private CauldronTileEntity cauldron;

    public CauldronTank(CauldronTileEntity cauldron) {
        this.cauldron = cauldron;
    }

    public int getTanks() {
        return 1;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return !stack.hasTag();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = this.cauldron.getState().getFluid();
        return fluid == null ? null : new FluidStack(fluid, 1000);
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        int max;
        if (stack.hasTag()) {
            return 0;
        }
        int level = this.cauldron.getFluidLevel();
        if (level == (max = InspirationsRegistry.getCauldronMax())) {
            return 0;
        }
        ICauldronRecipe.CauldronState state = this.cauldron.getState();
        if (level == max || level > 0 && state.getFluid() != stack.getFluid()) {
            return 0;
        }
        int toInsert = Math.min(CauldronTank.getLevels(stack.getAmount()), max - level);
        if (toInsert == 0) {
            return 0;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.cauldron.setState(ICauldronRecipe.CauldronState.fluid(stack.getFluid()), false);
            this.cauldron.setFluidLevel(toInsert + level);
        }
        return CauldronTank.getAmount(toInsert);
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        if (stack.hasTag()) {
            return null;
        }
        ICauldronRecipe.CauldronState state = this.cauldron.getState();
        if (state.getFluid() != stack.getFluid()) {
            return null;
        }
        return this.drain(stack.getAmount(), action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        ICauldronRecipe.CauldronState state = this.cauldron.getState();
        if (state.getFluid() == null) {
            return null;
        }
        int level = this.cauldron.getFluidLevel();
        if (level == 0) {
            return null;
        }
        int toDrain = Math.min(CauldronTank.getLevels(maxDrain), level);
        if (toDrain == 0) {
            return null;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE) {
            this.cauldron.setFluidLevel(level - toDrain);
        }
        return new FluidStack(state.getFluid(), CauldronTank.getAmount(toDrain));
    }

    private static int getLevels(int amount) {
        if (Config.enableBiggerCauldron()) {
            return amount / 250;
        }
        return amount >= 1000 ? 3 : 0;
    }

    private static int getAmount(int levels) {
        if (Config.enableBiggerCauldron()) {
            return levels * 250;
        }
        return levels == 3 ? 1000 : 0;
    }
}

