/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tileentity;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.block.EnhancedCauldronBlock;
import knightminer.inspirations.recipes.tank.CauldronTank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CauldronTileEntity
extends TileEntity {
    public static final DamageSource DAMAGE_BOIL = new DamageSource(Util.prefix("boiling")).func_76348_h();
    private ICauldronRecipe.CauldronState state = ICauldronRecipe.CauldronState.WATER;
    private CauldronTank tank = new CauldronTank(this);
    private static final String TAG_CAULDRON_CRAFTED = "cauldron_crafted";
    private static final String TAG_CAULDRON_COOLDOWN = "cauldron_cooldown";
    public static final String TAG_STATE = "state";

    public CauldronTileEntity() {
        super(TileEntityType.field_222489_z);
    }

    @Nonnull
    public EnhancedCauldronBlock.CauldronContents getContentType() {
        if (this.state.getFluid() != null) {
            return EnhancedCauldronBlock.CauldronContents.FLUID;
        }
        if (this.state.getColor() > -1) {
            return EnhancedCauldronBlock.CauldronContents.DYE;
        }
        if (this.state.getPotion() != null) {
            return EnhancedCauldronBlock.CauldronContents.POTION;
        }
        return EnhancedCauldronBlock.CauldronContents.FLUID;
    }

    public boolean isWater() {
        return this.state.isWater();
    }

    public ICauldronRecipe.CauldronState getState() {
        return this.state;
    }

    public int getColor() {
        switch (this.getContentType()) {
            case DYE: {
                return this.state.getColor();
            }
            case POTION: {
                return PotionUtils.func_185183_a((Potion)this.state.getPotion());
            }
        }
        Fluid fluid = this.state.getFluid();
        if (fluid != null) {
            return fluid.getAttributes().getColor();
        }
        return -1;
    }

    @Nonnull
    public IModelData getModelData() {
        Fluid fluid;
        if (this.getFluidLevel() > 0 && this.state != ICauldronRecipe.CauldronState.WATER && this.getContentType() == EnhancedCauldronBlock.CauldronContents.FLUID && (fluid = this.state.getFluid()) != null) {
            return new ModelDataMap.Builder().withInitial(EnhancedCauldronBlock.TEXTURE, (Object)fluid.getAttributes().getStillTexture().toString()).build();
        }
        return EmptyModelData.INSTANCE;
    }

    public static boolean interact(World world, BlockPos pos, BlockState blockState, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        CauldronTileEntity cauldron = null;
        ICauldronRecipe.CauldronState state = ICauldronRecipe.CauldronState.WATER;
        boolean boiling = false;
        Block block = blockState.func_177230_c();
        if (Config.enableExtendedCauldron() && block instanceof EnhancedCauldronBlock) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof CauldronTileEntity) {
                cauldron = (CauldronTileEntity)te;
                state = cauldron.state;
                boiling = (Boolean)blockState.func_177229_b((IProperty)EnhancedCauldronBlock.BOILING);
            }
        } else {
            state = InspirationsRegistry.getCauldronState(blockState);
            boiling = InspirationsRegistry.isCauldronFire(world.func_180495_p(pos.func_177977_b()));
        }
        int level = EnhancedCauldronBlock.getCauldronLevel(blockState);
        ICauldronRecipe recipe = InspirationsRegistry.getCauldronResult(stack, boiling, level, state);
        if (recipe != null) {
            if (!world.field_72995_K) {
                int newLevel;
                ICauldronRecipe.CauldronState newState = recipe.getState(stack, boiling, level, state);
                if (!Config.enableExtendedCauldron() && !ICauldronRecipe.CauldronState.WATER.matches(newState)) {
                    return true;
                }
                SoundEvent sound = recipe.getSound(stack, boiling, level, state);
                if (sound != null) {
                    world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, recipe.getVolume(sound), 1.0f);
                }
                if ((newLevel = recipe.getLevel(level)) != level || !state.matches(newState)) {
                    if (newLevel == InspirationsRegistry.getCauldronMax() && InspirationsRegistry.isNormalCauldron(blockState) && InspirationsRegistry.hasFullCauldron(newState)) {
                        world.func_175656_a(pos, InspirationsRegistry.getFullCauldron(newState));
                        cauldron = null;
                    } else {
                        if (!(block instanceof CauldronBlock)) {
                            TileEntity te;
                            ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, pos, Blocks.field_150383_bp.func_176223_P(), newLevel);
                            if (Config.enableExtendedCauldron() && (te = world.func_175625_s(pos)) instanceof CauldronTileEntity) {
                                cauldron = (CauldronTileEntity)te;
                            }
                        } else {
                            ((CauldronBlock)block).func_176590_a(world, pos, blockState, newLevel);
                        }
                        if (newLevel == 0) {
                            newState = ICauldronRecipe.CauldronState.WATER;
                        }
                    }
                }
                if (cauldron != null) {
                    cauldron.setState(newState, true);
                }
                ItemStack result = recipe.getResult(stack, boiling, level, state);
                if (!player.func_184812_l_()) {
                    ItemStack container = recipe.getContainer(stack);
                    int original = stack.func_190916_E();
                    ItemStack transform = recipe.transformInput(stack, boiling, level, state);
                    if (transform.func_190926_b()) {
                        if (!container.func_190926_b()) {
                            container.func_190920_e(container.func_190916_E() * original);
                            player.func_184611_a(hand, container);
                        }
                    } else {
                        player.func_184611_a(hand, transform);
                        if (!container.func_190926_b()) {
                            container.func_190920_e(container.func_190916_E() * (original - transform.func_190916_E()));
                            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)container, (int)player.field_71071_by.field_70461_c);
                        }
                    }
                }
                if (!result.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)result, (int)player.field_71071_by.field_70461_c);
                }
            }
            return true;
        }
        if (state.isWater()) {
            Item item = stack.func_77973_b();
            return state != ICauldronRecipe.CauldronState.WATER && (item == Items.field_151068_bn || item == Items.field_151131_as);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int onEntityCollide(Entity entity, int level, BlockState currentState) {
        block22: {
            block21: {
                if (!(entity instanceof ItemEntity)) break block21;
                entityItem = (ItemEntity)entity;
                entityTags = entity.getPersistentData();
                if (entityTags.func_74767_n("cauldron_crafted")) {
                    return level;
                }
                cooldown = entityTags.func_74762_e("cauldron_cooldown");
                if (cooldown > 0) {
                    entityTags.func_74768_a("cauldron_cooldown", cooldown - 1);
                    return level;
                }
                boiling = (Boolean)currentState.func_177229_b((IProperty)EnhancedCauldronBlock.BOILING);
                stack = entityItem.func_92059_d();
                recipe = InspirationsRegistry.getCauldronResult(stack, boiling, level, this.state);
                if (recipe != null) {
                    state = this.state;
                    sound = recipe.getSound(stack, boiling, level, state);
                    if (sound != null) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, sound, SoundCategory.BLOCKS, recipe.getVolume(sound), 1.0f);
                    }
                    matches = 0;
                    do {
                        newState = recipe.getState(stack, boiling, level, state);
                        if ((level = recipe.getLevel(level)) == 0) {
                            newState = ICauldronRecipe.CauldronState.WATER;
                        }
                        if (!(result = recipe.getResult(stack, boiling, level, state)).func_190926_b()) {
                            this.spawnItem(result, entityItem);
                        }
                        container = recipe.getContainer(stack);
                        oldCount = stack.func_190916_E();
                        stack = recipe.transformInput(stack, boiling, level, state);
                        if (container.func_190926_b()) continue;
                        container.func_190920_e(container.func_190916_E() * (oldCount - stack.func_190916_E()));
                        this.spawnItem(container, entityItem);
                    } while (recipe.matches(stack, boiling, level, state = newState) && ++matches < 10);
                    if (matches == 10) {
                        Inspirations.log.warn("Recipe '{}' matched too many times in a single tick. Either the level or the state should change to make it no longer match.", (Object)recipe);
                    }
                    if (stack.func_190926_b()) {
                        entityItem.func_70106_y();
                    } else {
                        entityItem.func_92058_a(stack);
                        entityTags.func_74757_a("cauldron_crafted", true);
                    }
                    if (!state.matches(this.state)) {
                        this.state = state;
                        this.field_145850_b.func_184138_a(this.field_174879_c, currentState, currentState, 2);
                    }
                } else {
                    entityTags.func_74768_a("cauldron_cooldown", 60);
                }
                break block22;
            }
            if (level <= 0) break block22;
            switch (1.$SwitchMap$knightminer$inspirations$recipes$block$EnhancedCauldronBlock$CauldronContents[this.getContentType().ordinal()]) {
                case 3: {
                    if (!this.isWater()) ** GOTO lbl54
                    if (entity.func_70027_ad()) {
                        entity.func_70066_B();
                        --level;
                    }
                    ** GOTO lbl60
lbl54:
                    // 1 sources

                    fluid = this.state.getFluid();
                    if (fluid.getAttributes().getTemperature() > 450 && !entity.func_70045_F()) {
                        entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                        entity.func_70015_d(15);
                        break;
                    }
                }
lbl60:
                // 4 sources

                case 1: {
                    if (!((Boolean)currentState.func_177229_b((IProperty)EnhancedCauldronBlock.BOILING)).booleanValue()) break;
                    entity.func_70097_a(CauldronTileEntity.DAMAGE_BOIL, 2.0f);
                    break;
                }
                case 2: {
                    if (!(entity instanceof LivingEntity)) break;
                    living = (LivingEntity)entity;
                    effects = this.state.getPotion().func_185170_a();
                    if (!effects.stream().anyMatch((Predicate<EffectInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onEntityCollide$0(net.minecraft.entity.LivingEntity net.minecraft.potion.EffectInstance ), (Lnet/minecraft/potion/EffectInstance;)Z)((LivingEntity)living))) break;
                    for (EffectInstance effect : effects) {
                        if (effect.func_188419_a().func_76403_b()) {
                            effect.func_188419_a().func_180793_a(null, null, living, effect.func_76458_c(), 1.0);
                            continue;
                        }
                        living.func_195064_c(new EffectInstance(effect));
                    }
                    --level;
                }
            }
        }
        return level;
    }

    private void spawnItem(ItemStack stack, ItemEntity base) {
        ItemEntity entityItem = new ItemEntity(this.field_145850_b, base.field_70165_t, base.field_70163_u, base.field_70161_v, stack);
        entityItem.getPersistentData().func_74757_a(TAG_CAULDRON_CRAFTED, true);
        this.field_145850_b.func_217376_c((Entity)entityItem);
    }

    public void onBreak(BlockPos pos, int level) {
        switch (this.getContentType()) {
            case FLUID: {
                BlockState block = this.state.getFluid().getAttributes().getBlock(null, null, this.state.getFluid().func_207188_f());
                if (block == null || level != (Config.enableBiggerCauldron() ? 4 : 3)) break;
                this.field_145850_b.func_175656_a(pos, block);
                break;
            }
            case POTION: {
                Potion potion = this.state.getPotion();
                AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_145850_b, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
                cloud.func_184483_a(0.5f * (float)level + 0.5f);
                cloud.func_184486_b(20 * (level + 1));
                cloud.func_184495_b(-0.5f);
                cloud.func_184485_d(10);
                cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
                cloud.func_184484_a(potion);
                for (EffectInstance effect : potion.func_185170_a()) {
                    cloud.func_184496_a(new EffectInstance(effect));
                }
                this.field_145850_b.func_217376_c((Entity)cloud);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    public int getFluidLevel() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof EnhancedCauldronBlock) {
            return ((EnhancedCauldronBlock)block).getLevel(state);
        }
        return 0;
    }

    public void setFluidLevel(int levels) {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof EnhancedCauldronBlock) {
            if (levels == 0) {
                this.state = ICauldronRecipe.CauldronState.WATER;
            }
            ((EnhancedCauldronBlock)block).func_176590_a(this.field_145850_b, this.field_174879_c, state, levels);
        }
    }

    public void setState(ICauldronRecipe.CauldronState newState, boolean doBlockUpdate) {
        if (!this.state.matches(newState)) {
            this.state = newState;
            if (doBlockUpdate) {
                BlockState blockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, blockstate, blockstate, 2);
            } else {
                this.func_70296_d();
            }
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags = super.func_189515_b(tags);
        tags.func_218657_a(TAG_STATE, (INBT)this.state.writeToNBT());
        return tags;
    }

    public void func_145839_a(CompoundNBT tags) {
        super.func_145839_a(tags);
        this.state = ICauldronRecipe.CauldronState.fromNBT(tags.func_74775_l(TAG_STATE));
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.state.writeToNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        ICauldronRecipe.CauldronState newState = ICauldronRecipe.CauldronState.fromNBT(pkt.func_148857_g());
        if (!this.state.matches(newState)) {
            this.state = newState;
            if (this.field_145850_b.field_72995_K) {
                Minecraft.func_71410_x().field_71438_f.func_184376_a(null, this.field_174879_c, null, null, 0);
            }
        }
    }

    private static /* synthetic */ boolean lambda$onEntityCollide$0(LivingEntity living, EffectInstance effect) {
        return !living.func_70644_a(effect.func_188419_a());
    }
}

