/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.shared.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.util.TextureBlockUtil;
import knightminer.inspirations.shared.SharedClientProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import slimeknights.mantle.client.ModelHelper;

public class TextureModel
extends BakedModelWrapper<IBakedModel> {
    private final Map<String, IBakedModel> cache = new HashMap<String, IBakedModel>();
    private IUnbakedModel unbakedModel;
    private final VertexFormat format;
    private final String textureKey;
    private boolean item;
    private Map<ResourceLocation, IModel> unbakedChildren;
    ModelProperty<String> TEXTURE = TextureBlockUtil.TEXTURE_PROP;

    public TextureModel(IBakedModel originalModel, IUnbakedModel unbakedModel, VertexFormat format, String textureKey, boolean item) {
        super(originalModel);
        this.unbakedModel = unbakedModel;
        this.format = format;
        this.textureKey = textureKey;
        this.item = item;
    }

    public void fetchChildren(ModelLoader loader) {
        HashSet missingTextures = new HashSet();
        this.unbakedModel.func_209559_a(arg_0 -> ((ModelLoader)loader).func_209597_a(arg_0), missingTextures);
        if (this.unbakedModel instanceof VariantList) {
            VariantList list = (VariantList)this.unbakedModel;
            if (list.func_188114_a().isEmpty()) {
                this.unbakedChildren = ImmutableMap.of();
                return;
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            HashSet<ResourceLocation> loaded = new HashSet<ResourceLocation>();
            for (Variant variant : list.func_188114_a()) {
                ResourceLocation location = variant.func_188046_a();
                if (loaded.contains(location)) continue;
                loaded.add(location);
                try {
                    IUnbakedModel model = loader.func_209597_a(location);
                    model.func_209559_a(arg_0 -> ((ModelLoader)loader).func_209597_a(arg_0), missingTextures);
                    builder.put((Object)location, (Object)model);
                }
                catch (Exception e) {
                    Inspirations.log.error("Error loading unbaked model for " + location, (Throwable)e);
                }
            }
            this.unbakedChildren = builder.build();
        }
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        IBakedModel bakedModel = this.originalModel;
        String texture = (String)extraData.getData(this.TEXTURE);
        if (texture != null) {
            bakedModel = this.getCachedTextureModel(texture);
        }
        return bakedModel.getQuads(state, side, rand, extraData);
    }

    protected IBakedModel getTexturedModel(ImmutableMap<String, String> textures) {
        if (textures.isEmpty()) {
            return this.originalModel;
        }
        if (this.unbakedModel instanceof VariantList) {
            return this.retextureVariantList((VariantList)this.unbakedModel, textures);
        }
        return this.retexture((IModel)this.unbakedModel, textures).bake((ModelBakery)SharedClientProxy.modelLoader, arg_0 -> ((AtlasTexture)Minecraft.func_71410_x().func_147117_R()).func_195424_a(arg_0), (ISprite)ModelRotation.X0_Y0, this.format);
    }

    protected IBakedModel getCachedTextureModel(String texture) {
        return this.cache.computeIfAbsent(texture, tex -> this.getTexturedModel((ImmutableMap<String, String>)ImmutableMap.of((Object)this.textureKey, (Object)tex)));
    }

    private IModel retexture(IModel model, ImmutableMap<String, String> textures) {
        if (model instanceof BlockModel) {
            return this.retextureBlockModel((BlockModel)model, textures);
        }
        return model.retexture(textures);
    }

    private BlockModel retextureBlockModel(BlockModel model, ImmutableMap<String, String> textures) {
        ArrayList elements = Lists.newArrayList();
        for (BlockPart part : model.func_178298_a()) {
            elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
        }
        BlockModel newModel = new BlockModel(model.getParentLocation(), (List)elements, (Map)Maps.newHashMap((Map)model.field_178318_c), model.func_178309_b(), model.func_178311_c(), model.func_181682_g(), (List)Lists.newArrayList((Iterable)model.func_187966_f()));
        newModel.field_178317_b = model.field_178317_b;
        newModel.field_178315_d = model.field_178315_d;
        HashSet removed = Sets.newHashSet();
        for (Map.Entry e : textures.entrySet()) {
            if ("".equals(e.getValue())) {
                removed.add(e.getKey());
                newModel.field_178318_c.remove(e.getKey());
                continue;
            }
            newModel.field_178318_c.put(e.getKey(), e.getValue());
        }
        HashMap remapped = Maps.newHashMap();
        for (Map.Entry e : newModel.field_178318_c.entrySet()) {
            String key;
            if (!((String)e.getValue()).startsWith("#") || !newModel.field_178318_c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
            remapped.put(e.getKey(), newModel.field_178318_c.get(key));
        }
        newModel.field_178318_c.putAll(remapped);
        for (BlockPart part : newModel.func_178298_a()) {
            part.field_178240_c.entrySet().removeIf(entry -> removed.contains(((BlockPartFace)entry.getValue()).field_178242_d));
        }
        return newModel;
    }

    private IBakedModel retextureVariantList(VariantList list, ImmutableMap<String, String> textures) {
        if (list.func_188114_a().isEmpty()) {
            return this.originalModel;
        }
        WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
        for (Variant variant : list.func_188114_a()) {
            IModel model = this.unbakedChildren.get(variant.func_188046_a());
            if (model == null) continue;
            IBakedModel ibakedmodel = this.retexture(model, textures).bake((ModelBakery)SharedClientProxy.modelLoader, arg_0 -> ((AtlasTexture)Minecraft.func_71410_x().func_147117_R()).func_195424_a(arg_0), (ISprite)variant, this.format);
            builder.func_177677_a(ibakedmodel, variant.func_188047_d());
        }
        IBakedModel baked = builder.func_209614_a();
        return baked != null ? baked : this.originalModel;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.item ? ItemTextureOverride.INSTANCE : super.func_188617_f();
    }

    private static class ItemTextureOverride
    extends ItemOverrideList {
        private static final ItemTextureOverride INSTANCE = new ItemTextureOverride();

        private ItemTextureOverride() {
        }

        @Nullable
        public IBakedModel func_209581_a(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
            Block block;
            if (originalModel instanceof TextureModel && (block = TextureBlockUtil.getTextureBlock(stack)) != Blocks.field_150350_a) {
                ResourceLocation texture = ModelHelper.getTextureFromBlockstate((BlockState)block.func_176223_P()).func_195668_m();
                TextureModel textureModel = (TextureModel)originalModel;
                return textureModel.getCachedTextureModel(texture.toString());
            }
            return originalModel;
        }
    }
}

