/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.tools.ToolsClientProxy;
import knightminer.inspirations.tools.ToolsEvents;
import knightminer.inspirations.tools.block.RedstoneChargeBlock;
import knightminer.inspirations.tools.client.BarometerPropertyGetter;
import knightminer.inspirations.tools.client.NorthCompassPropertyGetter;
import knightminer.inspirations.tools.client.PhotometerPropertyGetter;
import knightminer.inspirations.tools.enchantment.AxeDamageEnchantment;
import knightminer.inspirations.tools.enchantment.AxeLootBonusEnchantment;
import knightminer.inspirations.tools.enchantment.ExtendedFireAspectEnchantment;
import knightminer.inspirations.tools.enchantment.ExtendedKnockbackEnchantment;
import knightminer.inspirations.tools.enchantment.ShieldProtectionEnchantment;
import knightminer.inspirations.tools.enchantment.ShieldThornsEnchantment;
import knightminer.inspirations.tools.entity.RedstoneArrow;
import knightminer.inspirations.tools.item.EnchantableShieldItem;
import knightminer.inspirations.tools.item.RedstoneArrowItem;
import knightminer.inspirations.tools.item.RedstoneChargerItem;
import knightminer.inspirations.tools.item.WaypointCompassItem;
import knightminer.inspirations.tools.recipe.CopyWaypointCompassRecipe;
import knightminer.inspirations.tools.recipe.DyeWaypointCompassRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsTools", description="Adds various tools or tweaks to vanilla tools")
public class InspirationsTools
extends PulseBase {
    public static final String pulseID = "InspirationsTools";
    public static Object proxy = DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> new ToolsClientProxy());
    public static Item lock;
    public static Item key;
    public static Item redstoneCharger;
    public static Item northCompass;
    public static Item barometer;
    public static Item photometer;
    public static ArrowItem redstoneArrow;
    public static WaypointCompassItem[] waypointCompasses;
    public static Block redstoneCharge;
    public static EntityType<RedstoneArrow> entRSArrow;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ToolsEvents.class);
        this.registerDispenserBehavior();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        redstoneCharge = this.registerBlock((IForgeRegistry<Block>)r, new RedstoneChargeBlock(), "redstone_charge");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        Item.Properties toolProps = new Item.Properties().func_200916_a(ItemGroup.field_78040_i);
        redstoneArrow = this.registerItem((IForgeRegistry<Item>)r, new RedstoneArrowItem(toolProps), "charged_arrow");
        redstoneCharger = this.registerItem((IForgeRegistry<Item>)r, new RedstoneChargerItem(), "redstone_charger");
        lock = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78035_l), () -> ((ForgeConfigSpec.BooleanValue)Config.enableLock).get()), "lock");
        key = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78035_l), () -> ((ForgeConfigSpec.BooleanValue)Config.enableLock).get()), "key");
        northCompass = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(toolProps, () -> ((ForgeConfigSpec.BooleanValue)Config.enableNorthCompass).get()), "north_compass");
        northCompass.func_185043_a(Util.getResource("angle"), (IItemPropertyGetter)new NorthCompassPropertyGetter());
        barometer = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(toolProps, () -> ((ForgeConfigSpec.BooleanValue)Config.enableBarometer).get()), "barometer");
        barometer.func_185043_a(Util.getResource("height"), (IItemPropertyGetter)new BarometerPropertyGetter());
        photometer = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(toolProps, () -> ((ForgeConfigSpec.BooleanValue)Config.enablePhotometer).get()), "photometer");
        photometer.func_185043_a(Util.getResource("light"), (IItemPropertyGetter)new PhotometerPropertyGetter());
        InspirationsTools.waypointCompasses[DyeColor.WHITE.func_196059_a()] = this.registerItem((IForgeRegistry<Item>)r, new WaypointCompassItem(0xDDDDDD, 16761088, () -> ((ForgeConfigSpec.BooleanValue)Config.enableWaypointCompass).get()), "waypoint_compass");
        InspirationsTools.waypointCompasses[DyeColor.BLACK.func_196059_a()] = this.registerItem((IForgeRegistry<Item>)r, new WaypointCompassItem(0x444444, DyeColor.RED.field_193351_w), "black_waypoint_compass");
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.LIGHT_GRAY, DyeColor.WHITE.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.GRAY, DyeColor.LIGHT_GRAY.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.RED, DyeColor.ORANGE.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.ORANGE, DyeColor.YELLOW.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.YELLOW, 14393875);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.LIME, DyeColor.BROWN.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.GREEN, DyeColor.LIME.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.CYAN, DyeColor.LIGHT_BLUE.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.LIGHT_BLUE, 7842303);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.BLUE, 8279295);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.PURPLE, DyeColor.MAGENTA.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.MAGENTA, DyeColor.PINK.field_193351_w);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.PINK, 15908814);
        this.registerWaypointCompass((IForgeRegistry<Item>)r, DyeColor.BROWN, 10850418);
        if (Config.shieldEnchantmentTable()) {
            this.register(r, (IForgeRegistryEntry)new EnchantableShieldItem(new Item.Properties().func_200918_c(Items.field_185159_cQ.func_77612_l()).func_200916_a(ItemGroup.field_78037_j)), Items.field_185159_cQ.getRegistryName());
        }
    }

    private void registerWaypointCompass(IForgeRegistry<Item> r, DyeColor body, int needle) {
        InspirationsTools.waypointCompasses[body.func_196059_a()] = this.registerItem(r, new WaypointCompassItem(body.field_193351_w, needle), body.func_176762_d() + "_waypoint_compass");
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        r.register(entRSArrow);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        IForgeRegistry r = event.getRegistry();
        this.register(r, (IForgeRegistryEntry)CopyWaypointCompassRecipe.SERIALIZER, "copy_waypoint_compass");
        this.register(r, (IForgeRegistryEntry)DyeWaypointCompassRecipe.SERIALIZER, "dye_waypoint_compass");
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        EquipmentSlotType[] slots;
        IForgeRegistry r = event.getRegistry();
        if (((Boolean)Config.moreShieldEnchantments.get()).booleanValue()) {
            slots = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
            for (ProtectionEnchantment ench : new ProtectionEnchantment[]{(ProtectionEnchantment)Enchantments.field_180310_c, (ProtectionEnchantment)Enchantments.field_77329_d, (ProtectionEnchantment)Enchantments.field_180308_g, (ProtectionEnchantment)Enchantments.field_185297_d}) {
                this.register(r, (IForgeRegistryEntry)new ShieldProtectionEnchantment(ench.func_77324_c(), ench.field_77356_a, slots), ench.getRegistryName());
            }
            this.register(r, (IForgeRegistryEntry)new ShieldThornsEnchantment(Enchantments.field_92091_k.func_77324_c(), slots), Enchantments.field_92091_k.getRegistryName());
        }
        if (((Boolean)Config.moreShieldEnchantments.get()).booleanValue() || ((Boolean)Config.axeWeaponEnchants.get()).booleanValue()) {
            slots = new EquipmentSlotType[]{EquipmentSlotType.MAINHAND};
            this.register(r, (IForgeRegistryEntry)new ExtendedKnockbackEnchantment(Enchantment.Rarity.UNCOMMON, slots), new ResourceLocation("knockback"));
            this.register(r, (IForgeRegistryEntry)new ExtendedFireAspectEnchantment(Enchantment.Rarity.RARE, slots), new ResourceLocation("fire_aspect"));
            if (((Boolean)Config.axeWeaponEnchants.get()).booleanValue()) {
                this.register(r, (IForgeRegistryEntry)new AxeLootBonusEnchantment(Enchantment.Rarity.RARE, EnchantmentType.WEAPON, slots), new ResourceLocation("looting"));
            }
        }
        if (((Boolean)Config.axeEnchantmentTable.get()).booleanValue()) {
            slots = new EquipmentSlotType[]{EquipmentSlotType.MAINHAND};
            this.register(r, (IForgeRegistryEntry)new AxeDamageEnchantment(Enchantment.Rarity.COMMON, 0, slots), new ResourceLocation("sharpness"));
            this.register(r, (IForgeRegistryEntry)new AxeDamageEnchantment(Enchantment.Rarity.UNCOMMON, 1, slots), new ResourceLocation("smite"));
            this.register(r, (IForgeRegistryEntry)new AxeDamageEnchantment(Enchantment.Rarity.UNCOMMON, 2, slots), new ResourceLocation("bane_of_arthropods"));
        }
    }

    private void registerDispenserBehavior() {
        DispenserBlock.func_199774_a((IItemProvider)redstoneArrow, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            @Nonnull
            protected IProjectile func_82499_a(@Nonnull World world, @Nonnull IPosition position, @Nonnull ItemStack stack) {
                RedstoneArrow arrow = new RedstoneArrow(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)redstoneCharger, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            @Nonnull
            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                this.field_218407_b = true;
                World world = source.func_197524_h();
                Direction facing = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                BlockPos pos = source.func_180699_d().func_177972_a(facing);
                if (world.func_180495_p(pos).func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, pos, facing, ItemStack.field_190927_a, facing))) {
                    world.func_175656_a(pos, (BlockState)redstoneCharge.func_176223_P().func_206870_a((IProperty)RedstoneChargeBlock.FACING, (Comparable)facing));
                    if (stack.func_96631_a(1, world.field_73012_v, null)) {
                        stack.func_190920_e(0);
                    }
                } else {
                    this.field_218407_b = false;
                }
                return stack;
            }
        });
    }

    static {
        waypointCompasses = new WaypointCompassItem[16];
        entRSArrow = InspirationsTools.buildEntity(EntityType.Builder.func_220322_a(RedstoneArrow::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory((packet, world) -> new RedstoneArrow(entRSArrow, (World)world)), "redstone_arrow");
    }
}

