/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.client;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.tools.item.WaypointCompassItem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WaypointCompassPropertyGetter
implements IItemPropertyGetter {
    private Map<ItemStack, Wobble> wobbleMap = new WeakHashMap<ItemStack, Wobble>();

    @OnlyIn(value=Dist.CLIENT)
    public float call(@Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity entityIn) {
        LivingEntity entity;
        if (entityIn == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        boolean isHeld = entityIn != null;
        Object object = entity = isHeld ? entityIn : stack.func_82836_z();
        if (world == null || entity == null) {
            if (entity == null || entity.field_70170_p == null) {
                return 0.0f;
            }
            world = entity.field_70170_p;
        }
        double angle = this.getAngle(stack, world, (Entity)entity, isHeld);
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            angle = this.wobble(stack, world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getAngle(ItemStack stack, @Nonnull World world, @Nonnull Entity entity, boolean isHeld) {
        BlockPos pos;
        DimensionType dimension = WaypointCompassItem.getDimensionType(stack);
        if (dimension != null && (pos = WaypointCompassItem.getPos(stack, dimension, world.func_201675_m().func_186058_p())) != null) {
            double entityAngle = isHeld ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
            entityAngle = MathHelper.func_191273_b((double)(entityAngle / 360.0), (double)1.0);
            double posAngle = this.posToAngle(pos, entity) / (Math.PI * 2);
            return 0.5 - (entityAngle - 0.25 - posAngle);
        }
        return Math.random();
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getFrameRotation(ItemFrameEntity frame) {
        return MathHelper.func_188209_b((int)(180 + frame.func_174811_aO().func_176736_b() * 90));
    }

    @OnlyIn(value=Dist.CLIENT)
    private double posToAngle(BlockPos pos, Entity entity) {
        return Math.atan2((double)pos.func_177952_p() + 0.5 - entity.field_70161_v, (double)pos.func_177958_n() + 0.5 - entity.field_70165_t);
    }

    @OnlyIn(value=Dist.CLIENT)
    private double wobble(ItemStack stack, World world, double angle) {
        Wobble wobble = this.wobbleMap.computeIfAbsent(stack, s -> new Wobble());
        if (world.func_82737_E() != wobble.lastUpdateTick) {
            wobble.lastUpdateTick = world.func_82737_E();
            double newAngle = angle - wobble.rotation;
            newAngle = MathHelper.func_191273_b((double)(newAngle + 0.5), (double)1.0) - 0.5;
            wobble.rota += newAngle * 0.1;
            wobble.rota *= 0.8;
            wobble.rotation = MathHelper.func_191273_b((double)(wobble.rotation + wobble.rota), (double)1.0);
        }
        return wobble.rotation;
    }

    private static class Wobble {
        double rotation;
        double rota;
        long lastUpdateTick;

        private Wobble() {
        }
    }
}

