/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.util.TagUtil;
import knightminer.inspirations.tools.client.WaypointCompassPropertyGetter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;

public class WaypointCompassItem
extends HidableItem {
    public static final String TAG_POS = "pos";
    public static final String TAG_DIMENSION = "dimension";
    public static final String TAG_CHECK_BEACON = "check_beacon";
    private final int bodyColor;
    private final int needleColor;

    public WaypointCompassItem(int bodyColor, int needleColor) {
        this(bodyColor, needleColor, Config::dyeWaypointCompass);
    }

    public WaypointCompassItem(int bodyColor, int needleColor, Supplier<Boolean> enableFunc) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i), enableFunc);
        this.bodyColor = bodyColor;
        this.needleColor = needleColor;
        this.func_185043_a(Util.getResource("angle"), new WaypointCompassPropertyGetter());
    }

    public int getColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return this.bodyColor;
            }
            case 1: {
                return this.needleColor;
            }
        }
        return -1;
    }

    @Nonnull
    public String func_77658_a() {
        return "item.inspirations.waypoint_compass";
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !stack.func_77942_o() || world.func_82737_E() % 160L != 20L) {
            return;
        }
        DimensionType dimension = WaypointCompassItem.getDimensionType(stack);
        if (dimension != null) {
            ServerWorld other;
            if (dimension == world.func_201675_m().func_186058_p()) {
                this.checkPos(stack, world, WaypointCompassItem.getPos(stack));
            } else if (((Boolean)Config.waypointCompassCrossDimension.get()).booleanValue() && world.func_82737_E() % 320L == 20L && (other = DimensionManager.getWorld((MinecraftServer)world.func_73046_m(), (DimensionType)dimension, (boolean)false, (boolean)false)) != null) {
                this.checkPos(stack, (World)other, WaypointCompassItem.getPos(stack, dimension, other.func_201675_m().func_186058_p()));
            }
        }
    }

    public static boolean beaconIsComplete(TileEntity te) {
        if (!(te instanceof BeaconTileEntity)) {
            return false;
        }
        BeaconTileEntity beacon = (BeaconTileEntity)te;
        return beacon.func_191979_s() > 0 && beacon.field_174909_f.size() != 0;
    }

    private void checkPos(ItemStack stack, World world, BlockPos pos) {
        if (pos != null && world.func_175667_e(pos)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof BeaconTileEntity) {
                CompoundNBT tags = stack.func_196082_o();
                if (WaypointCompassItem.beaconIsComplete(te)) {
                    tags.func_82580_o(TAG_CHECK_BEACON);
                } else if (tags.func_74767_n(TAG_CHECK_BEACON)) {
                    WaypointCompassItem.clearNBT(stack);
                } else {
                    stack.func_196082_o().func_74757_a(TAG_CHECK_BEACON, true);
                }
            } else {
                WaypointCompassItem.clearNBT(stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!Inspirations.configLoaded) {
            return;
        }
        DimensionType type = WaypointCompassItem.getDimensionType(stack);
        if (type != null) {
            TranslationTextComponent prettyDim;
            ResourceLocation dimension = DimensionType.func_212678_a((DimensionType)type);
            if (dimension == null) {
                dimension = new ResourceLocation("null_dimension");
            }
            Object dimensionTooltip = !(prettyDim = new TranslationTextComponent("dimension." + dimension.func_110624_b() + "." + dimension.func_110623_a().replace('/', '.'), new Object[0])).func_150261_e().equals(prettyDim.func_150268_i()) ? prettyDim : new StringTextComponent(ClientUtil.normalizeName(dimension.func_110623_a()));
            if (flag == ITooltipFlag.TooltipFlags.ADVANCED) {
                BlockPos pos;
                dimensionTooltip.func_150257_a((ITextComponent)new StringTextComponent(String.format(" (%d)", WaypointCompassItem.getDimension(stack))));
                if (((Boolean)Config.waypointCompassAdvTooltip.get()).booleanValue() && !Minecraft.func_71410_x().func_189648_am() && (pos = WaypointCompassItem.getPos(stack)) != null) {
                    dimensionTooltip = new TranslationTextComponent(this.func_77658_a() + ".pos.tooltip", new Object[]{prettyDim, pos.func_177958_n(), pos.func_177952_p()});
                }
            }
            tooltip.add((ITextComponent)dimensionTooltip);
        } else if (Config.craftWaypointCompass()) {
            tooltip.add(new TranslationTextComponent(this.func_77658_a() + ".blank.tooltip", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true))));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".vanilla.tooltip", new Object[]{new TranslationTextComponent(Items.field_151111_aL.func_77658_a(), new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)))}));
        }
    }

    @Nullable
    public static Integer getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tags = stack.func_196082_o();
        return tags.func_150297_b(TAG_DIMENSION, 99) ? Integer.valueOf(tags.func_74762_e(TAG_DIMENSION)) : null;
    }

    @Nullable
    public static DimensionType getDimensionType(ItemStack stack) {
        Integer dimension = WaypointCompassItem.getDimension(stack);
        if (dimension != null) {
            try {
                return DimensionType.func_186069_a((int)dimension);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return TagUtil.readPos(stack.func_196082_o().func_74775_l(TAG_POS));
    }

    @Nullable
    public static BlockPos getPos(ItemStack stack, DimensionType compassDimension, DimensionType worldDimension) {
        BlockPos pos = WaypointCompassItem.getPos(stack);
        if (pos == null) {
            return null;
        }
        if (compassDimension != worldDimension) {
            if (!((Boolean)Config.waypointCompassCrossDimension.get()).booleanValue()) {
                return null;
            }
            if (compassDimension == DimensionType.field_223228_b_) {
                return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o(), pos.func_177952_p() * 8);
            }
            if (worldDimension == DimensionType.field_223228_b_) {
                return new BlockPos(Math.round((float)pos.func_177958_n() / 8.0f), pos.func_177956_o(), Math.round((float)pos.func_177952_p() / 8.0f));
            }
        }
        return pos;
    }

    public static void setNBT(@Nonnull ItemStack stack, @Nullable World world, @Nullable BlockPos pos) {
        if (world == null || pos == null) {
            WaypointCompassItem.clearNBT(stack);
            return;
        }
        WaypointCompassItem.setNBT(stack, world.func_201675_m().func_186058_p(), pos);
    }

    private static void clearNBT(ItemStack stack) {
        if (stack.func_82837_s()) {
            ITextComponent name = stack.func_200301_q();
            stack.func_77982_d(null);
            stack.func_200302_a(name);
        } else {
            stack.func_77982_d(null);
        }
    }

    public static void copyNBT(@Nonnull ItemStack stack, @Nonnull ItemStack waypoint) {
        if (!waypoint.func_77942_o()) {
            return;
        }
        WaypointCompassItem.setNBT(stack, WaypointCompassItem.getDimensionType(waypoint), WaypointCompassItem.getPos(waypoint));
    }

    private static void setNBT(@Nonnull ItemStack stack, DimensionType dimension, BlockPos pos) {
        if (pos == null) {
            stack.func_77982_d(null);
            return;
        }
        CompoundNBT tags = TagUtil.getTagSafe(stack);
        tags.func_74768_a(TAG_DIMENSION, dimension.func_186068_a());
        tags.func_218657_a(TAG_POS, (INBT)TagUtil.writePos(pos));
        stack.func_77982_d(tags);
    }

    public static int getNeedleColor(DyeColor color) {
        switch (color) {
            case WHITE: {
                return 16761088;
            }
            case LIGHT_GRAY: {
                return DyeColor.WHITE.field_193351_w;
            }
            case GRAY: {
                return DyeColor.LIGHT_GRAY.field_193351_w;
            }
            case BLACK: {
                return DyeColor.RED.field_193351_w;
            }
            case RED: {
                return DyeColor.ORANGE.field_193351_w;
            }
            case ORANGE: {
                return DyeColor.YELLOW.field_193351_w;
            }
            case YELLOW: {
                return 14393875;
            }
            case LIME: {
                return DyeColor.BROWN.field_193351_w;
            }
            case GREEN: {
                return DyeColor.LIME.field_193351_w;
            }
            case CYAN: {
                return DyeColor.LIGHT_BLUE.field_193351_w;
            }
            case LIGHT_BLUE: {
                return 7842303;
            }
            case BLUE: {
                return 8279295;
            }
            case PURPLE: {
                return DyeColor.MAGENTA.field_193351_w;
            }
            case MAGENTA: {
                return DyeColor.PINK.field_193351_w;
            }
            case PINK: {
                return 15908814;
            }
            case BROWN: {
                return 10850418;
            }
        }
        return -1;
    }

    public static boolean isWaypointCompass(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof WaypointCompassItem || !Config.craftWaypointCompass() && item == Items.field_151111_aL;
    }
}

