/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.recipe;

import java.util.function.Function;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tools.item.WaypointCompassItem;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CopyWaypointCompassRecipe
extends SpecialRecipe {
    public static Serializer SERIALIZER = new Serializer(CopyWaypointCompassRecipe::new);

    public CopyWaypointCompassRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World world) {
        if (!((Boolean)Config.enableWaypointCompass.get()).booleanValue()) {
            return false;
        }
        boolean foundWaypoint = false;
        ItemStack blank = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (!WaypointCompassItem.isWaypointCompass(stack)) {
                return false;
            }
            if (WaypointCompassItem.getDimension(stack) != null) {
                if (foundWaypoint) {
                    return false;
                }
                foundWaypoint = true;
                continue;
            }
            if (!blank.func_190926_b() && blank.func_77973_b() != stack.func_77973_b()) {
                return false;
            }
            blank = stack;
        }
        return foundWaypoint && !blank.func_190926_b();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack waypoint = ItemStack.field_190927_a;
        ItemStack result = ItemStack.field_190927_a;
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!WaypointCompassItem.isWaypointCompass(stack)) continue;
            if (WaypointCompassItem.getDimension(stack) != null) {
                waypoint = stack;
                continue;
            }
            result = stack;
            ++count;
        }
        if (!result.func_190926_b() && !waypoint.func_190926_b()) {
            result = result.func_77973_b() instanceof WaypointCompassItem ? result.func_77946_l() : new ItemStack((IItemProvider)InspirationsTools.waypointCompasses[DyeColor.WHITE.func_196059_a()]);
            result.func_190920_e(count);
            WaypointCompassItem.copyNBT(result, waypoint);
            return result;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList items = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof WaypointCompassItem) || WaypointCompassItem.getDimension(stack) == null) continue;
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            items.set(i, (Object)stack);
            break;
        }
        return items;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public String func_193358_e() {
        return "inspirations:waypoint_compass_copy";
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends SpecialRecipeSerializer<CopyWaypointCompassRecipe> {
        public Serializer(Function<ResourceLocation, CopyWaypointCompassRecipe> factory) {
            super(factory);
        }
    }
}

