/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.tweaks.TweaksClientProxy;
import knightminer.inspirations.tweaks.TweaksEvents;
import knightminer.inspirations.tweaks.block.FittedCarpetBlock;
import knightminer.inspirations.tweaks.block.FlatCarpetBlock;
import knightminer.inspirations.tweaks.recipe.NormalBrewingRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsTweaks", description="Various vanilla tweaks")
public class InspirationsTweaks
extends PulseBase {
    public static final String pulseID = "InspirationsTweaks";
    public static Object proxy = DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> new TweaksClientProxy());
    public static FittedCarpetBlock[] fitCarpets = new FittedCarpetBlock[16];
    public static FlatCarpetBlock[] flatCarpets = new FlatCarpetBlock[16];
    public static CropsBlock cactusCrop;
    public static CropsBlock sugarCaneCrop;
    public static Item potatoSeeds;
    public static Item carrotSeeds;
    public static Item sugarCaneSeeds;
    public static Item cactusSeeds;
    public static Item heartbeet;
    private static final IDispenseItemBehavior DEFAULT;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.WHITE, Blocks.field_196724_fH);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.ORANGE, Blocks.field_196725_fI);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.MAGENTA, Blocks.field_196727_fJ);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.LIGHT_BLUE, Blocks.field_196729_fK);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.YELLOW, Blocks.field_196731_fL);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.LIME, Blocks.field_196733_fM);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.PINK, Blocks.field_196735_fN);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.GRAY, Blocks.field_196737_fO);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.LIGHT_GRAY, Blocks.field_196739_fP);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.CYAN, Blocks.field_196741_fQ);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.PURPLE, Blocks.field_196743_fR);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.BLUE, Blocks.field_196745_fS);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.BROWN, Blocks.field_196747_fT);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.GREEN, Blocks.field_196749_fU);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.RED, Blocks.field_196751_fV);
        this.registerCarpet((IForgeRegistry<Block>)r, DyeColor.BLACK, Blocks.field_196753_fW);
    }

    private void registerCarpet(IForgeRegistry<Block> r, DyeColor color, Block origCarpet) {
        FlatCarpetBlock flatCarpetBlock = new FlatCarpetBlock(color, origCarpet);
        InspirationsTweaks.flatCarpets[color.func_196059_a()] = flatCarpetBlock;
        FlatCarpetBlock flatCarpet = flatCarpetBlock;
        FittedCarpetBlock fittedCarpetBlock = new FittedCarpetBlock(color, origCarpet);
        InspirationsTweaks.fitCarpets[color.func_196059_a()] = fittedCarpetBlock;
        FittedCarpetBlock fitCarpet = fittedCarpetBlock;
        this.register(r, (IForgeRegistryEntry)flatCarpet, origCarpet.getRegistryName());
        this.register(r, (IForgeRegistryEntry)fitCarpet, color.func_176610_l() + "_fitted_carpet");
    }

    @SubscribeEvent
    public void registerItem(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        for (FlatCarpetBlock carpet : flatCarpets) {
            BlockItem item = (BlockItem)this.register(r, (IForgeRegistryEntry)new BlockItem((Block)carpet, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)), carpet.getRegistryName());
            Item.field_179220_a.put(carpet, item);
            Item.field_179220_a.put(fitCarpets[carpet.func_196547_d().func_196059_a()], item);
        }
        heartbeet = this.registerItem((IForgeRegistry<Item>)r, new HidableItem(new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(new Food.Builder().func_221456_a(2).func_221454_a(2.4f).func_221452_a(new EffectInstance(Effects.field_76428_l, 100), 1.0f).func_221453_d()), () -> ((ForgeConfigSpec.BooleanValue)Config.enableHeartbeet).get()), "heartbeet");
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        Ingredient heartbeet = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{InspirationsTweaks.heartbeet});
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new NormalBrewingRecipe(Potions.field_185230_b, heartbeet, Potions.field_185231_c, Config::brewHeartbeet));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new NormalBrewingRecipe(Potions.field_185233_e, heartbeet, Potions.field_185220_C, Config::brewHeartbeet));
        this.registerDispenserBehavior();
        MinecraftForge.EVENT_BUS.register(TweaksEvents.class);
    }

    @SubscribeEvent
    public static void loadLoad(LootTableLoadEvent event) {
        InspirationsTweaks.addToVanillaLoot(event, "entities/cave_spider");
        InspirationsTweaks.addToVanillaLoot(event, "entities/skeleton");
    }

    private void registerDispenserBehavior() {
        IDispenseItemBehavior behavior = (source, stack) -> {
            if (!((Boolean)Config.dispensersPlaceAnvils.get()).booleanValue()) {
                DEFAULT.dispense(source, stack);
            }
            Direction facing = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            World world = source.func_197524_h();
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, facing, stack, facing.func_176734_d());
            if (((BlockItem)stack.func_77973_b()).func_195942_a((BlockItemUseContext)context) == ActionResultType.SUCCESS) {
                return stack;
            }
            return DEFAULT.dispense(source, stack);
        };
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_150467_bQ, (IDispenseItemBehavior)behavior);
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_196717_eY, (IDispenseItemBehavior)behavior);
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_196718_eZ, (IDispenseItemBehavior)behavior);
    }

    static {
        DEFAULT = new DefaultDispenseItemBehavior();
    }
}

