/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import java.util.Map;
import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.tweaks.client.PortalColorHandler;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TweaksClientProxy
extends ClientProxy {
    private static final ResourceLocation ENCHANTED_BOOK_VANILLA = new ModelResourceLocation("enchanted_book", "inventory");
    private static final ResourceLocation ENCHANTED_BOOK_TINTED = Util.getResource("item/enchanted_book");
    private static final ResourceLocation FIREWORKS_VANILLA = new ModelResourceLocation("firework_rocket", "inventory");
    private static final ResourceLocation FIREWORKS_TINTED = Util.getResource("item/fireworks");
    private static final ResourceLocation PORTAL_EW_VANILLA = new ModelResourceLocation("minecraft:nether_portal", "axis=z");
    private static final ResourceLocation PORTAL_NS_VANILLA = new ModelResourceLocation("minecraft:nether_portal", "axis=x");
    private static final ResourceLocation PORTAL_EW_TINTED = Util.getResource("block/nether_portal_tinted_ew");
    private static final ResourceLocation PORTAL_NS_TINTED = Util.getResource("block/nether_portal_tinted_ns");
    private static final ResourceLocation CAULDRON_MODEL_VANILLA = new ModelResourceLocation("cauldron", "inventory");
    private static final ResourceLocation CAULDRON_ITEM_MODEL = new ModelResourceLocation(Util.getResource("cauldron"), "inventory");

    @SubscribeEvent
    public void loadCustomModels(ModelRegistryEvent event) {
        ModelLoader.addSpecialModel((ResourceLocation)PORTAL_EW_TINTED);
        ModelLoader.addSpecialModel((ResourceLocation)PORTAL_NS_TINTED);
        ModelLoader.addSpecialModel((ResourceLocation)ENCHANTED_BOOK_TINTED);
        ModelLoader.addSpecialModel((ResourceLocation)FIREWORKS_TINTED);
        ModelLoader.addSpecialModel((ResourceLocation)CAULDRON_ITEM_MODEL);
    }

    @SubscribeEvent
    public void swapModels(ModelBakeEvent event) {
        Map map = event.getModelRegistry();
        if (((Boolean)Config.betterCauldronItem.get()).booleanValue()) {
            map.put(CAULDRON_MODEL_VANILLA, map.get(CAULDRON_ITEM_MODEL));
        }
        if (((Boolean)Config.customPortalColor.get()).booleanValue()) {
            map.put(PORTAL_EW_VANILLA, map.get(PORTAL_EW_TINTED));
            map.put(PORTAL_NS_VANILLA, map.get(PORTAL_NS_TINTED));
        }
        if (((Boolean)Config.coloredEnchantedRibbons.get()).booleanValue()) {
            map.put(ENCHANTED_BOOK_VANILLA, map.get(ENCHANTED_BOOK_TINTED));
        }
        if (((Boolean)Config.coloredFireworkItems.get()).booleanValue()) {
            map.put(FIREWORKS_VANILLA, map.get(FIREWORKS_TINTED));
        }
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        TweaksClientProxy.registerBlockColors(colors, (state, world, pos, index) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return BiomeColors.func_217613_a((IEnviromentBlockReader)world, (BlockPos)pos);
        }, new Block[]{InspirationsTweaks.sugarCaneCrop});
        TweaksClientProxy.registerBlockColors(colors, PortalColorHandler.INSTANCE, Blocks.field_150427_aO);
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        itemColors.func_199877_a((stack, tintIndex) -> {
            if (tintIndex == 0 && ((Boolean)Config.coloredEnchantedRibbons.get()).booleanValue()) {
                Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
                for (INBT tag : EnchantedBookItem.func_92110_g((ItemStack)stack)) {
                    Enchantment.Rarity newRarity;
                    ResourceLocation id;
                    Enchantment enchantment;
                    if (tag.func_74732_a() != 10 || (enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id = new ResourceLocation(((CompoundNBT)tag).func_74779_i("id")))) == null || (newRarity = enchantment.func_77324_c()) == null || newRarity.func_185270_a() >= rarity.func_185270_a()) continue;
                    rarity = newRarity;
                }
                switch (rarity) {
                    case COMMON: {
                        return 16720209;
                    }
                    case UNCOMMON: {
                        return 14845997;
                    }
                    case RARE: {
                        return 65313;
                    }
                    case VERY_RARE: {
                        return 0x9F7FFF;
                    }
                }
            }
            return -1;
        }, new IItemProvider[]{Items.field_151134_bR});
        itemColors.func_199877_a((stack, tintIndex) -> {
            if (!((Boolean)Config.coloredFireworkItems.get()).booleanValue()) {
                return -1;
            }
            CompoundNBT nbt = stack.func_179543_a("Fireworks");
            if (tintIndex == 2) {
                if (nbt != null && nbt.func_150297_b("Flight", 99)) {
                    byte flight = nbt.func_74771_c("Flight");
                    switch (flight) {
                        case 1: {
                            return 0x808080;
                        }
                        case 2: {
                            return 0x606060;
                        }
                        case 3: {
                            return 0x303030;
                        }
                    }
                    if (flight > 3) {
                        return 0;
                    }
                }
                return 0xA0A0A0;
            }
            if (tintIndex == 0 || tintIndex == 1) {
                int missing;
                int n = missing = tintIndex == 1 ? 13410704 : 0xC0C0C0;
                if (nbt == null) {
                    return missing;
                }
                ListNBT stars = nbt.func_150295_c("Explosions", 10);
                if (tintIndex >= stars.size()) {
                    return missing;
                }
                CompoundNBT star = stars.func_150305_b(tintIndex);
                int[] colors = star.func_74759_k("Colors");
                if (colors.length > 0) {
                    return colors[0];
                }
                return missing;
            }
            return -1;
        }, new IItemProvider[]{Items.field_196152_dE});
    }

    @SubscribeEvent
    public static void fixShieldTooltip(ItemTooltipEvent event) {
        if (!((Boolean)Config.fixShieldTooltip.get()).booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() != Items.field_185159_cQ) {
            return;
        }
        CompoundNBT tags = stack.func_179543_a("BlockEntityTag");
        if (tags != null && tags.func_74764_b("Patterns") && stack.func_77948_v()) {
            ListNBT patterns = tags.func_150295_c("Patterns", 10);
            event.getToolTip().add(patterns.size() + 1, new StringTextComponent(""));
        }
    }
}

