/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.registries.IRegistryDelegate;

public abstract class BlockCropBlock
extends CropsBlock
implements IHidable,
IPlantable {
    protected IRegistryDelegate<Block> block;
    protected PlantType type;
    protected final VoxelShape[] shape;
    public static final IntegerProperty SMALL_AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)6);

    public BlockCropBlock(Block block, PlantType type, VoxelShape[] shape, Block.Properties props) {
        super(props);
        this.block = block.delegate;
        this.shape = shape;
        this.type = type;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.enableMoreSeeds.get();
    }

    @Deprecated
    public boolean func_196260_a(@Nonnull BlockState state, IWorldReader world, BlockPos pos) {
        BlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{this.func_185524_e()});
    }

    @Nonnull
    public IntegerProperty func_185524_e() {
        return SMALL_AGE;
    }

    @Nonnull
    public BlockState func_185528_e(int age) {
        if (age == this.func_185526_g()) {
            return ((Block)this.block.get()).func_176223_P();
        }
        return super.func_185528_e(age);
    }

    public boolean func_185525_y(BlockState state) {
        return false;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shape[this.func_185527_x(state)];
    }

    @Deprecated
    @Nonnull
    public VoxelShape func_199600_g(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        return this.shape[this.func_185527_x(state)];
    }

    @Nonnull
    protected abstract IItemProvider func_199772_f();

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return this.type;
    }
}

