/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.client;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBeaconBeamColorProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;

public class PortalColorHandler
implements IBlockColor {
    private static final int DEFAULT_COLOR = 10037503;
    private static final Set<Block> BEACON_COLOR_BLACKLIST = new HashSet<Block>();
    public static final PortalColorHandler INSTANCE = new PortalColorHandler();

    private PortalColorHandler() {
    }

    public int getColor(@Nonnull BlockState state, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos, int tintValue) {
        BlockPos above;
        if (!((Boolean)Config.customPortalColor.get()).booleanValue()) {
            return -1;
        }
        if (world == null || pos == null) {
            return 10037503;
        }
        if (world instanceof ChunkRenderCache) {
            world = ((ChunkRenderCache)world).field_212408_i;
        }
        if (pos.func_177956_o() % 16 == 15 && world.func_180495_p(above = pos.func_177984_a()).func_177230_c() == Blocks.field_150427_aO) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_213165_a(() -> mc.field_71438_f.func_184376_a(null, above, null, null, 8));
        }
        pos = pos.func_177977_b();
        while (world.func_180495_p(pos).func_177230_c() == Blocks.field_150427_aO) {
            pos = pos.func_177977_b();
        }
        return PortalColorHandler.getColorValue(world, pos.func_177977_b());
    }

    private static int getColorValue(IEnviromentBlockReader access, BlockPos pos) {
        BlockState state = access.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IBeaconBeamColorProvider) {
            return ((IBeaconBeamColorProvider)block).func_196457_d().field_193351_w;
        }
        if (!BEACON_COLOR_BLACKLIST.contains(block) && access instanceof IWorldReader) {
            IWorldReader world = (IWorldReader)access;
            try {
                float[] color = block.getBeaconColorMultiplier(state, world, pos, pos);
                if (color != null && color.length == 3) {
                    return Util.getColorInteger(color);
                }
            }
            catch (ClassCastException e) {
                Inspirations.log.error("Error getting beacon color for block", (Throwable)e);
                BEACON_COLOR_BLACKLIST.add(block);
            }
        }
        return 10037503;
    }
}

