/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility;

import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.utility.UtilityClientProxy;
import knightminer.inspirations.utility.UtilityEvents;
import knightminer.inspirations.utility.block.CarpetedPressurePlateBlock;
import knightminer.inspirations.utility.block.CarpetedTrapdoorBlock;
import knightminer.inspirations.utility.block.CollectorBlock;
import knightminer.inspirations.utility.block.PipeBlock;
import knightminer.inspirations.utility.block.TorchLevelBlock;
import knightminer.inspirations.utility.block.TorchLeverWallBlock;
import knightminer.inspirations.utility.inventory.CollectorContainer;
import knightminer.inspirations.utility.inventory.PipeContainer;
import knightminer.inspirations.utility.item.TorchLeverItem;
import knightminer.inspirations.utility.tileentity.CollectorTileEntity;
import knightminer.inspirations.utility.tileentity.PipeTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsUtility", description="Adds various utilities")
public class InspirationsUtility
extends PulseBase {
    public static final String pulseID = "InspirationsUtility";
    public static Object proxy = DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> new UtilityClientProxy());
    public static Block torchLeverWall;
    public static Block torchLeverFloor;
    public static Block[] carpetedTrapdoors;
    public static Block[] carpetedPressurePlates;
    public static Block collector;
    public static Block pipe;
    public static Item pipeItem;
    public static TileEntityType<CollectorTileEntity> tileCollector;
    public static TileEntityType<PipeTileEntity> tilePipe;
    public static ContainerType<CollectorContainer> contCollector;
    public static ContainerType<PipeContainer> contPipe;
    private DispenserRegAccess dispenserReg = new DispenserRegAccess();

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        torchLeverFloor = this.registerBlock((IForgeRegistry<Block>)r, new TorchLevelBlock(), "torch_lever");
        torchLeverWall = this.registerBlock((IForgeRegistry<Block>)r, new TorchLeverWallBlock(), "wall_torch_lever");
        for (DyeColor color : DyeColor.values()) {
            InspirationsUtility.carpetedTrapdoors[color.func_196059_a()] = this.registerBlock((IForgeRegistry<Block>)r, new CarpetedTrapdoorBlock(color), color.func_176610_l() + "_carpeted_trapdoor");
            InspirationsUtility.carpetedPressurePlates[color.func_196059_a()] = this.registerBlock((IForgeRegistry<Block>)r, new CarpetedPressurePlateBlock(color), color.func_176610_l() + "_carpeted_pressure_plate");
        }
        collector = this.registerBlock((IForgeRegistry<Block>)r, new CollectorBlock(), "collector");
        pipe = this.registerBlock((IForgeRegistry<Block>)r, new PipeBlock(), "pipe");
    }

    @SubscribeEvent
    public void registerTEs(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        tileCollector = (TileEntityType)this.register(r, (IForgeRegistryEntry)TileEntityType.Builder.func_223042_a(CollectorTileEntity::new, (Block[])new Block[]{collector}).func_206865_a(null), "collector");
        tilePipe = (TileEntityType)this.register(r, (IForgeRegistryEntry)TileEntityType.Builder.func_223042_a(PipeTileEntity::new, (Block[])new Block[]{pipe}).func_206865_a(null), "pipe");
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        contCollector = (ContainerType)this.register(r, (IForgeRegistryEntry)new ContainerType((ContainerType.IFactory)new CollectorContainer.Factory()), "collector");
        contPipe = (ContainerType)this.register(r, (IForgeRegistryEntry)new ContainerType((ContainerType.IFactory)new PipeContainer.Factory()), "pipe");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        this.register(r, (IForgeRegistryEntry)new TorchLeverItem(), "torch_lever");
        for (Block trapdoor : carpetedTrapdoors) {
            this.registerBlockItem((IForgeRegistry<Item>)r, trapdoor, ItemGroup.field_78028_d);
        }
        this.registerBlockItem((IForgeRegistry<Item>)r, collector, ItemGroup.field_78028_d);
        pipeItem = this.registerBlockItem((IForgeRegistry<Item>)r, pipe, ItemGroup.field_78028_d);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        this.registerDispenserBehavior();
        MinecraftForge.EVENT_BUS.register(UtilityEvents.class);
    }

    private void registerDispenserBehavior() {
    }

    static {
        carpetedTrapdoors = new Block[16];
        carpetedPressurePlates = new Block[16];
    }

    private static class DispenserRegAccess
    extends DispenserBlock {
        DispenserRegAccess() {
            super(Block.Properties.func_200945_a((Material)Material.field_151579_a));
        }

        IDispenseItemBehavior getRegisteredBehaviour(Item item) {
            return super.func_149940_a(new ItemStack((IItemProvider)item));
        }
    }
}

