/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import javax.annotation.Nonnull;
import knightminer.inspirations.Inspirations;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistries;

public class CarpetedPressurePlateBlock
extends PressurePlateBlock {
    protected static final VoxelShape PRESSED_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.25, (double)15.0));
    protected static final VoxelShape UNPRESSED_AABB = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0));
    private final DyeColor color;
    private final String transKey;
    private Item pickItem = Items.field_190931_a;

    public CarpetedPressurePlateBlock(DyeColor color) {
        super(PressurePlateBlock.Sensitivity.MOBS, Block.Properties.func_200952_a((Material)Material.field_151593_r, (DyeColor)color).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g));
        this.color = color;
        this.transKey = String.format("block.minecraft.%s_carpet", color.func_176762_d());
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        boolean flag = this.func_176576_e(state) > 0;
        return flag ? PRESSED_AABB : UNPRESSED_AABB;
    }

    @Nonnull
    public String func_149739_a() {
        return this.transKey;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.pickItem == Items.field_190931_a) {
            this.pickItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.color.func_176762_d() + "_carpet"));
            if (this.pickItem == Items.field_190931_a) {
                Inspirations.log.warn("No carpet item registered under minecraft:{}_carpet!", (Object)this.color.func_176762_d());
                return ItemStack.field_190927_a;
            }
        }
        return new ItemStack((IItemProvider)this.pickItem);
    }
}

