/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.dispenser;

import javax.annotation.Nonnull;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenseFluidTank
extends DefaultDispenseItemBehavior {
    private static final DefaultDispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    private IDispenseItemBehavior fallback;

    public DispenseFluidTank(IDispenseItemBehavior fallback) {
        this.fallback = fallback;
    }

    @Nonnull
    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        if (!stack.func_77973_b().func_206844_a(InspirationsRegistry.TAG_DISP_FLUID_TANKS)) {
            return this.fallback.dispense(source, stack);
        }
        Direction side = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(side);
        World world = source.func_197524_h();
        return (ItemStack)FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)side.func_176734_d()).map(handler -> {
            LazyOptional optFluid = FluidUtil.getFluidContained((ItemStack)stack);
            FluidActionResult result = optFluid.isPresent() ? FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true) : FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
            if (result.isSuccess()) {
                ItemStack resultStack = result.getResult();
                SoundEvent sound = (SoundEvent)optFluid.map(fluid -> fluid.getFluid().getAttributes().getEmptySound(fluid)).orElseGet(() -> {
                    FluidStack resultFluid = (FluidStack)FluidUtil.getFluidContained((ItemStack)resultStack).orElseThrow(AssertionError::new);
                    return resultFluid.getFluid().getAttributes().getFillSound(resultFluid);
                });
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (stack.func_190916_E() == 1) {
                    return resultStack;
                }
                if (!resultStack.func_190926_b() && ((DispenserTileEntity)source.func_150835_j()).func_146019_a(resultStack) < 0) {
                    DEFAULT.dispense(source, resultStack);
                }
                ItemStack shrink = stack.func_77946_l();
                shrink.func_190918_g(1);
                return shrink;
            }
            return DEFAULT.dispense(source, stack);
        }).orElseGet(() -> this.fallback.dispense(source, stack));
    }
}

