/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.inventory.CollectorContainer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.tileentity.InventoryTileEntity;

public class CollectorTileEntity
extends InventoryTileEntity {
    public static ITextComponent TITLE = new TranslationTextComponent("gui.inspirations.collector", new Object[0]);

    public CollectorTileEntity() {
        super(InspirationsUtility.tileCollector, TITLE, 9);
    }

    public void collect(Direction facing) {
        BlockPos offset = this.field_174879_c.func_177972_a(facing);
        TileEntity te = this.field_145850_b.func_175625_s(offset);
        if (te != null) {
            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).ifPresent(neighbor -> {
                for (int i = 0; i < neighbor.getSlots(); ++i) {
                    ItemStack simulated = neighbor.extractItem(i, 1, true);
                    if (simulated.func_190926_b() || !ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)simulated, (boolean)false).func_190926_b()) continue;
                    neighbor.extractItem(i, 1, false);
                    break;
                }
            });
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), (double)(offset.func_177958_n() + 1), (double)(offset.func_177956_o() + 1), (double)(offset.func_177952_p() + 1));
        boolean collected = false;
        for (ItemEntity entity : this.field_145850_b.func_217357_a(ItemEntity.class, aabb)) {
            ItemStack insert = entity.func_92059_d();
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)insert, (boolean)false);
            if (remainder.func_190916_E() >= insert.func_190916_E()) continue;
            collected = true;
            if (remainder.func_190926_b()) {
                entity.func_70106_y();
                continue;
            }
            entity.func_92058_a(remainder);
        }
        this.field_145850_b.func_217379_c(collected ? 1000 : 1001, this.field_174879_c, 0);
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
        return slot < this.func_70302_i_();
    }

    @Nullable
    public Container createMenu(int winId, @Nonnull PlayerInventory playerInv, @Nonnull PlayerEntity player) {
        return new CollectorContainer(winId, playerInv, this);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = this.getTileData().func_74737_b();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }
}

