/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;

public abstract class SlotlessItemHandlerWrapper
implements ISlotlessItemHandler {
    private final IItemHandler itemHandler;

    public SlotlessItemHandlerWrapper(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    protected abstract int getNonFullSlotWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract int getNonEmptySlotWithItemStack(@Nonnull ItemStack var1, int var2);

    protected abstract int getEmptySlot();

    protected abstract int getNonEmptySlot();

    @Override
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        int slot = this.getNonFullSlotWithItemStack(stack, 3);
        if (slot < 0) {
            slot = this.getEmptySlot();
        }
        if (slot < 0) {
            return stack;
        }
        return this.itemHandler.insertItem(slot, stack, simulate);
    }

    @Override
    public ItemStack extractItem(int amount, boolean simulate) {
        int slot = this.getNonEmptySlot();
        if (slot < 0) {
            return null;
        }
        return this.itemHandler.extractItem(slot, amount, simulate);
    }

    @Override
    public ItemStack extractItem(@Nonnull ItemStack matchStack, int matchFlags, boolean simulate) {
        int slot = this.getNonEmptySlotWithItemStack(matchStack, matchFlags);
        if (slot < 0) {
            return null;
        }
        return this.itemHandler.extractItem(slot, matchStack.field_77994_a, simulate);
    }
}

