/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.Achievement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.AchievementButton;
import org.cyclops.cyclopscore.infobook.pageelement.AchievementCollectButton;
import org.cyclops.cyclopscore.infobook.pageelement.AchievementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;

public class AchievementRewardsAppendix
extends SectionAppendix {
    public static final int SLOT_SIZE = 16;
    private static final int SLOT_PADDING = 2;
    public static final int MAX_WIDTH = 80;
    private static final AdvancedButton.Enum COLLECT = AdvancedButton.Enum.create();
    private final AdvancedButton.Enum[] rewards;
    private final AdvancedButton.Enum[] achievements;
    private final Point[] rewardPositions;
    private final AchievementRewards achievementRewards;
    private final int height;
    private final boolean enableRewards;
    protected Map<AdvancedButton.Enum, AdvancedButton> renderButtonHolders = Maps.newHashMap();

    public AchievementRewardsAppendix(IInfoBook infoBook, AchievementRewards achievementRewards) {
        super(infoBook);
        int i;
        this.achievementRewards = achievementRewards;
        this.rewards = new AdvancedButton.Enum[achievementRewards.getRewards().size()];
        this.achievements = new AdvancedButton.Enum[achievementRewards.getAchievements().size()];
        this.rewardPositions = new Point[achievementRewards.getRewards().size()];
        int x = 0;
        int y = 0;
        int row_max_y = 0;
        int max_width = 0;
        int max_height = 0;
        for (i = 0; i < achievementRewards.getRewards().size(); ++i) {
            IReward reward = achievementRewards.getRewards().get(i);
            this.rewards[i] = AdvancedButton.Enum.create();
            row_max_y = Math.max(row_max_y, reward.getHeight() + 4);
            if (x + reward.getWidth() > 80) {
                y += row_max_y;
                max_width = Math.max(x, max_width);
                max_height = Math.max(row_max_y, max_height);
                x = 0;
                row_max_y = 0;
            }
            this.rewardPositions[i] = new Point(x, y);
            x += reward.getWidth();
        }
        for (i = 0; i < achievementRewards.getAchievements().size(); ++i) {
            this.achievements[i] = AdvancedButton.Enum.create();
        }
        this.height = y + Math.max(row_max_y, max_height);
        this.enableRewards = infoBook.getMod().getReferenceValue(ModBase.REFKEY_INFOBOOK_REWARDS);
    }

    @Override
    protected int getOffsetY() {
        return 0;
    }

    @Override
    protected int getWidth() {
        return 80;
    }

    @Override
    protected int getHeight() {
        return this.height + (int)Math.ceil(this.achievementRewards.getAchievements().size() * 20 / 80 + 1) * 20 + 23;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int offsetX = 0;
        int offsetY = 0;
        gui.drawOuterBorder(x - 1, y - 1, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2);
        gui.drawScaledCenteredString(L10NHelpers.localize("gui.achievements"), x, y - 2, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt(30, 20, 120));
        offsetY += 10;
        boolean allAchievementsValid = true;
        for (int i = 0; i < this.achievementRewards.getAchievements().size(); ++i) {
            Achievement achievement = this.achievementRewards.getAchievements().get(i);
            if (offsetX + 16 > 80) {
                offsetY += 20;
                offsetX = 0;
            }
            RecipeAppendix.renderItemForButton(gui, x + offsetX, y + offsetY, achievement.field_75990_d, mx, my, true, null);
            if (Minecraft.func_71410_x().field_71439_g.func_146107_m().func_77443_a(achievement)) {
                Images.OK.draw((Gui)gui, x + offsetX + 1, y + offsetY + 2);
            } else {
                allAchievementsValid = false;
            }
            this.renderButtonHolders.get(this.achievements[i]).update(x + offsetX, y + offsetY, "", null, gui);
            offsetX += 20;
        }
        boolean taken = this.achievementRewards.isObtained((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        gui.drawTextBanner(x + width / 2, y - 2 + (offsetY += 26));
        boolean hovering = mx > x && mx < x + this.getWidth() && my > y + offsetY - 10 && my < y + offsetY + 5;
        gui.drawScaledCenteredString(L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards"), x, y - 2 + offsetY, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt(30, 20, 120));
        this.renderButtonHolders.get(COLLECT).update(x, y - 8 + offsetY, "", null, gui);
        if (allAchievementsValid && !taken) {
            float g = hovering ? 1.0f : (float)(gui.getTick() % 20) / 20.0f * 0.4f + 0.6f;
            float r = hovering ? 0.2f : 0.7f;
            float b = hovering ? 0.2f : 0.7f;
            GlStateManager.func_179124_c((float)r, (float)g, (float)b);
            Images.ARROW_DOWN.draw((Gui)gui, x, y + offsetY - 11);
            Images.ARROW_DOWN.draw((Gui)gui, x + 60, y + offsetY - 11);
        }
        offsetY += 10;
        for (int i = 0; i < this.achievementRewards.getRewards().size(); ++i) {
            this.achievementRewards.getRewards().get(i).drawElementInner(gui, x + this.rewardPositions[i].x, y + this.rewardPositions[i].y + offsetY, width, height, page, mx, my, this.renderButtonHolders.get(this.rewards[i]));
            if (taken) {
                Images.OK.draw((Gui)gui, x + this.rewardPositions[i].x + 1, y + this.rewardPositions[i].y + offsetY + 2);
                continue;
            }
            if (allAchievementsValid) continue;
            Images.ERROR.draw((Gui)gui, x + this.rewardPositions[i].x + 1, y + this.rewardPositions[i].y + offsetY + 2);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void postDrawElement(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, mx, my);
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderToolTips(GuiInfoBook gui, int mx, int my) {
        for (AdvancedButton button : this.renderButtonHolders.values()) {
            button.renderTooltip(mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderButtonHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        int i;
        this.renderButtonHolders.put(COLLECT, new AchievementCollectButton(this.achievementRewards, this.getInfoBook()));
        for (i = 0; i < this.achievementRewards.getRewards().size(); ++i) {
            this.renderButtonHolders.put(this.rewards[i], this.achievementRewards.getRewards().get(i).createButton(this.getInfoBook()));
        }
        for (i = 0; i < this.achievementRewards.getAchievements().size(); ++i) {
            this.renderButtonHolders.put(this.achievements[i], new AchievementButton(this.achievementRewards.getAchievements().get(i)));
        }
        infoSection.addAdvancedButtons(this.getPage(), this.renderButtonHolders.values());
    }
}

