/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;

public class FurnaceRecipeAppendix
extends RecipeAppendix<Map.Entry<ItemStack, ItemStack>> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 3;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButton.Enum INPUT = AdvancedButton.Enum.create();
    private static final AdvancedButton.Enum RESULT = AdvancedButton.Enum.create();

    public FurnaceRecipeAppendix(IInfoBook infoBook, Map.Entry<ItemStack, ItemStack> recipe) {
        super(infoBook, recipe);
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeightInner() {
        return 22;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "tile.furnace.name";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton(this.getInfoBook()));
        super.bakeElement(infoSection);
    }

    @Override
    public void drawElementInner(GuiInfoBook gui, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(x + middle - 3, y + 3 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStack((ItemStack)((Map.Entry)this.recipe).getKey(), tick);
        ItemStack result = this.prepareItemStack((ItemStack)((Map.Entry)this.recipe).getValue(), tick);
        this.renderItem(gui, x + 16, y + 3, input, mx, my, INPUT);
        this.renderItem(gui, x + 68, y + 3, result, mx, my, RESULT);
        this.renderItem(gui, x + middle, y + 3, new ItemStack(Blocks.field_150460_al), mx, my, false, null);
    }
}

