/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.player.ItemCraftedAchievements;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.block.BlockCrystalizedMenrilBlockConfig;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;
import org.cyclops.integrateddynamics.block.BlockDryingBasinConfig;
import org.cyclops.integrateddynamics.block.BlockLogicProgrammer;
import org.cyclops.integrateddynamics.block.BlockLogicProgrammerConfig;
import org.cyclops.integrateddynamics.block.BlockMaterializer;
import org.cyclops.integrateddynamics.block.BlockMaterializerConfig;
import org.cyclops.integrateddynamics.block.BlockMenrilLogFilledConfig;
import org.cyclops.integrateddynamics.block.BlockProxy;
import org.cyclops.integrateddynamics.block.BlockProxyConfig;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.block.BlockSqueezerConfig;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.core.evaluate.expression.LazyExpression;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.event.LogicProgrammerVariableFacadeCreatedEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.core.part.event.PartReaderAspectEvent;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.event.PartWriterAspectEvent;
import org.cyclops.integrateddynamics.item.ItemVariable;
import org.cyclops.integrateddynamics.item.ItemVariableConfig;
import org.cyclops.integrateddynamics.item.ItemVariableTransformerConfig;
import org.cyclops.integrateddynamics.item.ItemWrench;
import org.cyclops.integrateddynamics.item.ItemWrenchConfig;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class Achievements {
    private static final Achievements _INSTANCE = new Achievements();
    public static final Achievement MENEGLIN_DISCOVERY = new ExtendedAchievement("meneglinDiscovery", -1, 0, new ItemStack(ConfigHandler.isEnabled(BlockMenrilLogFilledConfig.class) ? BlockMenrilLogFilledConfig._instance.getBlockInstance() : Blocks.field_150364_r), null);
    public static final Achievement SQUEEZING = new ExtendedAchievement("squeezing", -1, 1, new ItemStack((Block)(ConfigHandler.isEnabled(BlockSqueezerConfig.class) ? BlockSqueezer.getInstance() : Blocks.field_150364_r)), MENEGLIN_DISCOVERY);
    public static final Achievement DRYING = new ExtendedAchievement("drying", -1, 2, new ItemStack((Block)(ConfigHandler.isEnabled(BlockDryingBasinConfig.class) ? BlockDryingBasin.getInstance() : Blocks.field_150364_r)), SQUEEZING);
    public static final Achievement MENRIL_PRODUCTION = new ExtendedAchievement("menrilProduction", 0, 3, new ItemStack(ConfigHandler.isEnabled(BlockCrystalizedMenrilBlockConfig.class) ? BlockCrystalizedMenrilBlockConfig._instance.getBlockInstance() : Blocks.field_150364_r), DRYING);
    public static final Achievement CABLES = new ExtendedAchievement("cablesLogic", 0, 4, new ItemStack((Block)(ConfigHandler.isEnabled(CableConfig.class) ? BlockCable.getInstance() : Blocks.field_150364_r)), MENRIL_PRODUCTION);
    public static final Achievement NETWORKS = new ExtendedAchievement("networksLogic", 1, 2, new ItemStack((Block)(ConfigHandler.isEnabled(CableConfig.class) ? BlockCable.getInstance() : Blocks.field_150364_r)), CABLES);
    public static final Achievement WRENCHING = new ExtendedAchievement("menrilWrenching", 2, 3, new ItemStack((Item)(ConfigHandler.isEnabled(ItemWrenchConfig.class) ? ItemWrench.getInstance() : Items.field_151034_e)), MENRIL_PRODUCTION);
    public static final Achievement VARIABLES = new ExtendedAchievement("variables", 2, 2, new ItemStack((Item)(ConfigHandler.isEnabled(ItemVariableConfig.class) ? ItemVariable.getInstance() : Items.field_151034_e)), MENRIL_PRODUCTION);
    public static final Achievement VARIABLEINPUT = new ExtendedAchievement("variableInput", 2, 1, new ItemStack(ConfigHandler.isEnabled(ItemVariableTransformerConfig.class) ? ItemVariableTransformerConfig._instance.getItemInstance() : Items.field_151034_e, 1, 1), MENRIL_PRODUCTION);
    public static final Achievement VARIABLEOUTPUT = new ExtendedAchievement("variableOutput", 3, 0, new ItemStack(ConfigHandler.isEnabled(ItemVariableTransformerConfig.class) ? ItemVariableTransformerConfig._instance.getItemInstance() : Items.field_151034_e, 1, 0), MENRIL_PRODUCTION);
    public static final Achievement REDSTONE_READING = new ExtendedAchievement("redstoneReading", 1, -1, new ItemStack(PartTypes.REDSTONE_READER.getItem()), VARIABLEINPUT);
    public static final Achievement BLOCK_READING = new ExtendedAchievement("blockReading", 1, -2, new ItemStack(PartTypes.BLOCK_READER.getItem()), VARIABLEINPUT);
    public static final Achievement INVENTORY_READING = new ExtendedAchievement("inventoryReading", 1, -3, new ItemStack(PartTypes.INVENTORY_READER.getItem()), VARIABLEINPUT);
    public static final Achievement VALUE_DISPLAYING = new ExtendedAchievement("valueDisplaying", 4, -1, new ItemStack(PartTypes.DISPLAY_PANEL.getItem()), VARIABLEOUTPUT);
    public static final Achievement REDSTONE_CAPTURING = new ExtendedAchievement("redstoneCapturing", 0, -2, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeAspectItemStack(Aspects.Read.Redstone.INTEGER_VALUE) : new ItemStack(Items.field_151034_e), REDSTONE_READING);
    public static final Achievement REDSTONE_OBSERVEMENT = new ExtendedAchievement("redstoneObservement", -1, -2, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueTypeInteger.ValueInteger.of(10)) : new ItemStack(Items.field_151034_e), REDSTONE_READING);
    public static final Achievement REDSTONE_TRANSMISSION = new ExtendedAchievement("redstoneTransmission", -2, -2, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeAspectItemStack(Aspects.Write.Redstone.INTEGER) : new ItemStack(Items.field_151034_e), REDSTONE_READING);
    public static final Achievement LOGIC_PROGRAMMING = new ExtendedAchievement("logicProgramming", 4, 2, new ItemStack((Block)(ConfigHandler.isEnabled(BlockLogicProgrammerConfig.class) ? BlockLogicProgrammer.getInstance() : Blocks.field_150462_ai)), VARIABLES);
    public static final Achievement CONSTANT_DEFINITION = new ExtendedAchievement("constantDefinition", 4, 3, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueTypeInteger.ValueInteger.of(10)) : new ItemStack(Items.field_151034_e), VARIABLES);
    public static final Achievement ARITHMETIC_ADDITION = new ExtendedAchievement("arithmeticAddition", 4, 4, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueTypeInteger.ValueInteger.of(20)) : new ItemStack(Items.field_151034_e), VARIABLES);
    public static final Achievement VARIABLE_MATERIALIZATION = new ExtendedAchievement("variableMaterialization", 4, 5, new ItemStack((Block)(ConfigHandler.isEnabled(BlockMaterializerConfig.class) ? BlockMaterializer.getInstance() : Blocks.field_150462_ai)), VARIABLES);
    public static final Achievement VARIABLE_PROXYING = new ExtendedAchievement("variableProxying", 4, 6, new ItemStack((Block)(ConfigHandler.isEnabled(BlockProxyConfig.class) ? BlockProxy.getInstance() : Blocks.field_150462_ai)), VARIABLES);
    public static final Achievement LOGICAL_LIST_BUILDING = new ExtendedAchievement("logicalListBuilding", 5, 1, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueTypeList.ValueList.ofAll((IValue[])new ValueTypeInteger.ValueInteger[]{ValueTypeInteger.ValueInteger.of(1), ValueTypeInteger.ValueInteger.of(10), ValueTypeInteger.ValueInteger.of(100)})) : new ItemStack(Items.field_151034_e), LOGIC_PROGRAMMING);
    public static final Achievement ITEM_ORIGIN_IDENTIFICATION = new ExtendedAchievement("itemOriginIdentification", 6, 1, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack(Items.field_151034_e))) : new ItemStack(Items.field_151034_e), LOGIC_PROGRAMMING);
    public static final Achievement WHAT_WOULD_I_BE_LOOKING_AT = new ExtendedAchievement("whatWouldIBeLookingAt", 7, 1, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueObjectTypeBlock.ValueBlock.of(Blocks.field_150348_b.func_176223_P())) : new ItemStack(Items.field_151034_e), LOGIC_PROGRAMMING);
    public static final Achievement DYNAMIC_ADDITIONS = new ExtendedAchievement("dynamicAdditions", 8, 1, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueTypeOperator.ValueOperator.of(Operators.ARITHMETIC_ADDITION)) : new ItemStack(Items.field_151034_e), LOGIC_PROGRAMMING);
    public static final Achievement DYNAMIC_LIST_FILTERING = new ExtendedAchievement("dynamicListFiltering", 9, 1, ConfigHandler.isEnabled(ItemVariableConfig.class) ? Achievements.makeValueItemStack(ValueTypeOperator.ValueOperator.of(Operators.OPERATOR_FILTER)) : new ItemStack(Items.field_151034_e), LOGIC_PROGRAMMING);
    public static final Achievement CREEPER_TAMING = new ExtendedAchievement("creeperTaming", 8, 2, new ItemStack(Items.field_151144_bL, 1, 4), WHAT_WOULD_I_BE_LOOKING_AT).func_75987_b();
    public static final Achievement SPONGE_STEP_SOUND = new ExtendedAchievement("spongeStepSound", 8, 3, new ItemStack(Blocks.field_150360_v, 1, 1), WHAT_WOULD_I_BE_LOOKING_AT).func_75987_b();
    public static final Achievement RECURSIVE_RECURSION = new ExtendedAchievement("recursiveRecursion", 6, 2, new ItemStack((Item)(ConfigHandler.isEnabled(ItemVariableConfig.class) ? ItemVariable.getInstance() : Items.field_151034_e)), WHAT_WOULD_I_BE_LOOKING_AT).func_75987_b();
    public static final Achievement TOOL_FOR_OBSIDIAN = new ExtendedAchievement("toolForObsidian", 6, 3, new ItemStack(Blocks.field_150343_Z), WHAT_WOULD_I_BE_LOOKING_AT).func_75987_b();
    public static final Achievement SMART_PRESSURE_PLATE = new ExtendedAchievement("smartPressurePlate", 7, 4, new ItemStack(Blocks.field_150443_bT), WHAT_WOULD_I_BE_LOOKING_AT).func_75987_b();
    private static final Achievement[] ACHIEVEMENTS = new Achievement[]{MENEGLIN_DISCOVERY, SQUEEZING, DRYING, MENRIL_PRODUCTION, CABLES, NETWORKS, WRENCHING, VARIABLES, VARIABLEINPUT, VARIABLEOUTPUT, REDSTONE_READING, BLOCK_READING, INVENTORY_READING, VALUE_DISPLAYING, REDSTONE_CAPTURING, REDSTONE_OBSERVEMENT, REDSTONE_TRANSMISSION, LOGIC_PROGRAMMING, CONSTANT_DEFINITION, ARITHMETIC_ADDITION, VARIABLE_MATERIALIZATION, VARIABLE_PROXYING, LOGICAL_LIST_BUILDING, ITEM_ORIGIN_IDENTIFICATION, WHAT_WOULD_I_BE_LOOKING_AT, DYNAMIC_ADDITIONS, DYNAMIC_LIST_FILTERING, CREEPER_TAMING, SPONGE_STEP_SOUND, RECURSIVE_RECURSION, TOOL_FOR_OBSIDIAN, SMART_PRESSURE_PLATE};

    public static ItemStack makeAspectItemStack(IAspect aspect) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(new ItemStack((Item)ItemVariable.getInstance()), new AspectVariableFacade(false, 0, aspect), Aspects.REGISTRY);
    }

    public static ItemStack makeValueItemStack(IValue value) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(new ItemStack((Item)ItemVariable.getInstance()), new ValueTypeVariableFacade<IValue>(false, value.getType(), value), ValueTypes.REGISTRY);
    }

    private Achievements() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void registerAchievements() {
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Integrated Dynamics", ACHIEVEMENTS));
        if (ConfigHandler.isEnabled(BlockSqueezerConfig.class)) {
            ItemCraftedAchievements.register((Item)Item.func_150898_a((Block)BlockSqueezer.getInstance()), (Achievement)SQUEEZING);
        }
        if (ConfigHandler.isEnabled(BlockDryingBasinConfig.class)) {
            ItemCraftedAchievements.register((Item)Item.func_150898_a((Block)BlockDryingBasin.getInstance()), (Achievement)DRYING);
        }
        if (ConfigHandler.isEnabled(CableConfig.class)) {
            ItemCraftedAchievements.register((Item)Item.func_150898_a((Block)BlockCable.getInstance()), (Achievement)CABLES);
        }
        if (ConfigHandler.isEnabled(ItemWrenchConfig.class)) {
            ItemCraftedAchievements.register((Item)ItemWrench.getInstance(), (Achievement)WRENCHING);
        }
        if (ConfigHandler.isEnabled(ItemVariableConfig.class)) {
            ItemCraftedAchievements.register((Item)ItemVariable.getInstance(), (Achievement)VARIABLES);
        }
        if (ConfigHandler.isEnabled(ItemVariableTransformerConfig.class)) {
            ItemCraftedAchievements.register((Item)ItemVariableTransformerConfig._instance.getItemInstance(), (Achievement)VARIABLEINPUT, (Predicate)new Predicate<ItemStack>(){

                public boolean apply(ItemStack input) {
                    return input.func_77960_j() == 1;
                }
            });
        }
        if (ConfigHandler.isEnabled(ItemVariableTransformerConfig.class)) {
            ItemCraftedAchievements.register((Item)ItemVariableTransformerConfig._instance.getItemInstance(), (Achievement)VARIABLEOUTPUT, (Predicate)new Predicate<ItemStack>(){

                public boolean apply(ItemStack input) {
                    return input.func_77960_j() == 0;
                }
            });
        }
        ItemCraftedAchievements.register((Item)PartTypes.REDSTONE_READER.getItem(), (Achievement)REDSTONE_READING);
        ItemCraftedAchievements.register((Item)PartTypes.BLOCK_READER.getItem(), (Achievement)BLOCK_READING);
        ItemCraftedAchievements.register((Item)PartTypes.INVENTORY_READER.getItem(), (Achievement)INVENTORY_READING);
        ItemCraftedAchievements.register((Item)PartTypes.DISPLAY_PANEL.getItem(), (Achievement)VALUE_DISPLAYING);
    }

    @SubscribeEvent
    public void onCrafted(NetworkInitializedEvent event) {
        if (event.getPlacer() != null && event.getPlacer() instanceof EntityPlayer && event.getNetwork().getCablesCount() >= 10) {
            ((EntityPlayer)event.getPlacer()).func_71029_a((StatBase)NETWORKS);
        }
    }

    @SubscribeEvent
    public void onPartReaderAspect(PartReaderAspectEvent event) {
        if (event.getPartType() == PartTypes.REDSTONE_READER && event.getAspect() == Aspects.Read.Redstone.INTEGER_VALUE && event.getEntityPlayer() != null) {
            event.getEntityPlayer().func_71029_a((StatBase)REDSTONE_CAPTURING);
        }
    }

    @SubscribeEvent
    public void onPartVariableDrivenUpdateEvent(PartVariableDrivenVariableContentsUpdatedEvent event) {
        if (event.getPartType() == PartTypes.DISPLAY_PANEL && event.getEntityPlayer() != null && event.getValue() != null) {
            if (event.getVariable() instanceof IAspectVariable && ((IAspectVariable)event.getVariable()).getAspect() == Aspects.Read.Redstone.INTEGER_VALUE) {
                event.getEntityPlayer().func_71029_a((StatBase)REDSTONE_OBSERVEMENT);
            } else if (event.getVariable() instanceof LazyExpression) {
                if (((LazyExpression)event.getVariable()).getOperator() == Operators.ARITHMETIC_ADDITION) {
                    event.getEntityPlayer().func_71029_a((StatBase)ARITHMETIC_ADDITION);
                } else if (((LazyExpression)event.getVariable()).getOperator() == Operators.OBJECT_ITEMSTACK_MODNAME) {
                    event.getEntityPlayer().func_71029_a((StatBase)ITEM_ORIGIN_IDENTIFICATION);
                } else if (((LazyExpression)event.getVariable()).getOperator() == Operators.OBJECT_PLAYER_TARGETBLOCK) {
                    event.getEntityPlayer().func_71029_a((StatBase)WHAT_WOULD_I_BE_LOOKING_AT);
                } else if (((LazyExpression)event.getVariable()).getOperator() == Operators.OPERATOR_APPLY) {
                    IVariable variable;
                    if (((LazyExpression)event.getVariable()).getInput().length == 2 && (variable = ((LazyExpression)event.getVariable()).getInput()[0]) instanceof LazyExpression && ((LazyExpression)variable).getOperator() == Operators.OPERATOR_APPLY) {
                        try {
                            Object value = event.getVariable().getValue();
                            if (value.getType() == ValueTypes.INTEGER) {
                                event.getEntityPlayer().func_71029_a((StatBase)DYNAMIC_ADDITIONS);
                            }
                        }
                        catch (EvaluationException value) {}
                    }
                } else if (((LazyExpression)event.getVariable()).getOperator() == Operators.OPERATOR_FILTER) {
                    try {
                        Object value = event.getVariable().getValue();
                        if (value.getType() == ValueTypes.LIST && ((ValueTypeList.ValueList)value).getRawValue().getLength() == 1 && ((ValueTypeList.ValueList)value).getRawValue().get(0).getType() == ValueTypes.INTEGER && ((ValueTypeInteger.ValueInteger)((ValueTypeList.ValueList)value).getRawValue().get(0)).getRawValue() == 10) {
                            event.getEntityPlayer().func_71029_a((StatBase)DYNAMIC_LIST_FILTERING);
                        }
                    }
                    catch (EvaluationException value) {}
                } else if (((LazyExpression)event.getVariable()).getOperator() == Operators.OBJECT_ENTITY_HEALTH) {
                    try {
                        Object value0 = ((LazyExpression)event.getVariable()).getInput()[0].getValue();
                        if (value0.getType() == ValueTypes.OBJECT_ENTITY && ((ValueObjectTypeEntity.ValueEntity)value0).getRawValue().isPresent() && ((ValueObjectTypeEntity.ValueEntity)value0).getRawValue().get() instanceof EntityCreeper) {
                            event.getEntityPlayer().func_71029_a((StatBase)CREEPER_TAMING);
                        }
                    }
                    catch (EvaluationException value0) {}
                } else if (((LazyExpression)event.getVariable()).getOperator() == Operators.OBJECT_ITEMSTACK_CAN_HARVEST_BLOCK) {
                    try {
                        Object value0 = ((LazyExpression)event.getVariable()).getInput()[0].getValue();
                        Object value1 = ((LazyExpression)event.getVariable()).getInput()[1].getValue();
                        if (value0.getType() == ValueTypes.OBJECT_ITEMSTACK && ((ValueObjectTypeItemStack.ValueItemStack)value0).getRawValue().isPresent() && ((ItemStack)((ValueObjectTypeItemStack.ValueItemStack)value0).getRawValue().get()).func_77973_b() == Items.field_151050_s && value1.getType() == ValueTypes.OBJECT_BLOCK && ((ValueObjectTypeBlock.ValueBlock)value1).getRawValue().isPresent() && ((IBlockState)((ValueObjectTypeBlock.ValueBlock)value1).getRawValue().get()).func_177230_c() == Blocks.field_150343_Z) {
                            event.getEntityPlayer().func_71029_a((StatBase)TOOL_FOR_OBSIDIAN);
                        }
                    }
                    catch (EvaluationException value0) {}
                } else if (event.getVariable().getType() == ValueTypes.LIST) {
                    try {
                        Object value0 = event.getVariable().getValue();
                        if (((ValueTypeList.ValueList)value0).getRawValue().isInfinite()) {
                            event.getEntityPlayer().func_71029_a((StatBase)RECURSIVE_RECURSION);
                        }
                    }
                    catch (EvaluationException e) {
                        e.printStackTrace();
                    }
                }
            } else if (event.getVariable() instanceof Variable && event.getVariable().getType() == ValueTypes.LIST) {
                IValueTypeListProxy list = ((ValueTypeList.ValueList)event.getValue()).getRawValue();
                try {
                    if (list.getLength() == 3 && list.getValueType() == ValueTypes.INTEGER && ((ValueTypeInteger.ValueInteger)list.get(0)).getRawValue() == 1 && ((ValueTypeInteger.ValueInteger)list.get(1)).getRawValue() == 10 && ((ValueTypeInteger.ValueInteger)list.get(2)).getRawValue() == 100) {
                        event.getEntityPlayer().func_71029_a((StatBase)LOGICAL_LIST_BUILDING);
                    } else if (list.isInfinite()) {
                        event.getEntityPlayer().func_71029_a((StatBase)RECURSIVE_RECURSION);
                    }
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void onPartWriterAspect(PartWriterAspectEvent event) {
        try {
            Object value0;
            IVariable variable = ((IPartStateWriter)event.getPartState()).getVariable(event.getPartNetwork());
            if (event.getPartType() == PartTypes.REDSTONE_WRITER && event.getEntityPlayer() != null) {
                if (event.getAspect() == Aspects.Write.Redstone.INTEGER && variable.getValue() instanceof ValueTypeInteger.ValueInteger && ((ValueTypeInteger.ValueInteger)variable.getValue()).getRawValue() >= 15 || event.getAspect() == Aspects.Write.Redstone.BOOLEAN && variable.getValue() instanceof ValueTypeBoolean.ValueBoolean && ((ValueTypeBoolean.ValueBoolean)variable.getValue()).getRawValue()) {
                    event.getEntityPlayer().func_71029_a((StatBase)REDSTONE_TRANSMISSION);
                } else if (event.getAspect() == Aspects.Write.Redstone.BOOLEAN && variable.getValue() instanceof ValueTypeBoolean.ValueBoolean && variable instanceof LazyExpression && ((LazyExpression)variable).getOperator() == Operators.RELATIONAL_EQUALS) {
                    IVariable varCheck;
                    IVariable varName;
                    IVariable var0 = ((LazyExpression)variable).getInput()[0];
                    IVariable var1 = ((LazyExpression)variable).getInput()[1];
                    if (var0 instanceof Variable) {
                        varName = var0;
                        varCheck = var1;
                    } else {
                        varName = var1;
                        varCheck = var0;
                    }
                    if (varName.getType() == ValueTypes.STRING && event.getEntityPlayer().func_70005_c_().equals(((ValueTypeString.ValueString)varName.getValue()).getRawValue()) && varCheck instanceof LazyExpression && ((LazyExpression)varCheck).getInput()[0] instanceof IAspectVariable && ((IAspectVariable)((LazyExpression)varCheck).getInput()[0]).getAspect() == Aspects.Read.Entity.ENTITY) {
                        event.getEntityPlayer().func_71029_a((StatBase)SMART_PRESSURE_PLATE);
                    }
                }
            } else if (event.getPartType() == PartTypes.AUDIO_WRITER && event.getAspect() == Aspects.Write.Audio.STRING_SOUND && event.getEntityPlayer() != null && variable instanceof LazyExpression && ((LazyExpression)variable).getOperator() == Operators.OBJECT_BLOCK_STEPSOUND && (value0 = ((LazyExpression)variable).getInput()[0].getValue()).getType() == ValueTypes.OBJECT_BLOCK && ((ValueObjectTypeBlock.ValueBlock)value0).getRawValue().isPresent() && ((Boolean)((IBlockState)((ValueObjectTypeBlock.ValueBlock)value0).getRawValue().get()).func_177229_b((IProperty)BlockSponge.field_176313_a)).booleanValue()) {
                event.getEntityPlayer().func_71029_a((StatBase)SPONGE_STEP_SOUND);
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onVariableFacadeCreated(LogicProgrammerVariableFacadeCreatedEvent event) {
        if (event.getBlock() == BlockLogicProgrammer.getInstance() && event.getVariableFacade() instanceof IValueTypeVariableFacade && ((IValueTypeVariableFacade)event.getVariableFacade()).getValueType() == ValueTypes.INTEGER) {
            event.getPlayer().func_71029_a((StatBase)CONSTANT_DEFINITION);
        } else if (event.getBlock() == BlockMaterializer.getInstance()) {
            event.getPlayer().func_71029_a((StatBase)VARIABLE_MATERIALIZATION);
        } else if (event.getBlock() == BlockProxy.getInstance() && event.getVariableFacade() instanceof IProxyVariableFacade) {
            event.getPlayer().func_71029_a((StatBase)VARIABLE_PROXYING);
        }
    }

    static class ExtendedAchievement
    extends Achievement {
        public ExtendedAchievement(String id, int column, int row, ItemStack item, Achievement parent) {
            super("integrateddynamics." + id, "integrateddynamics." + id, column, row, item, parent);
            this.func_75971_g();
        }
    }
}

