/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.evaluate.variable;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;

public interface IValueType<V extends IValue> {
    public boolean isCategory();

    public boolean isObject();

    public V getDefault();

    public String getTypeName();

    public String getUnlocalizedName();

    public void loadTooltip(List<String> var1, boolean var2, @Nullable V var3);

    public String toCompactString(V var1);

    public int getDisplayColor();

    public String getDisplayColorFormat();

    public boolean correspondsTo(IValueType var1);

    public String serialize(V var1);

    public L10NHelpers.UnlocalizedString canDeserialize(String var1);

    public V deserialize(String var1);

    public V materialize(V var1) throws EvaluationException;

    public IValueTypeLogicProgrammerElement createLogicProgrammerElement();

    public static class ValueTypeComparator
    implements Comparator<IValueType> {
        private static ValueTypeComparator INSTANCE = null;

        private ValueTypeComparator() {
        }

        public static ValueTypeComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ValueTypeComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(IValueType o1, IValueType o2) {
            return o1.getUnlocalizedName().compareTo(o2.getUnlocalizedName());
        }
    }
}

