/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class PartPos {
    private final DimPos pos;
    private final EnumFacing side;

    public static PartPos of(World world, BlockPos pos, EnumFacing side) {
        return PartPos.of(DimPos.of((World)world, (BlockPos)pos), side);
    }

    public static PartPos of(DimPos pos, EnumFacing side) {
        return new PartPos(pos, side);
    }

    private PartPos(DimPos pos, EnumFacing side) {
        this.pos = pos;
        this.side = side;
    }

    public DimPos getPos() {
        return this.pos;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PartPos)) {
            return false;
        }
        PartPos partPos = (PartPos)o;
        if (!this.pos.equals((Object)partPos.pos)) {
            return false;
        }
        return this.side == partPos.side;
    }

    public int hashCode() {
        return 31 * this.pos.hashCode() + (this.side != null ? this.side.hashCode() : 0);
    }

    public String toString() {
        return "PartPos{pos=" + this.pos + ", side=" + this.side + '}';
    }

    public static Pair<IPartType, IPartState> getPartData(PartPos pos) {
        IPartContainer partContainer = PartHelpers.getPartContainer(pos.getPos());
        if (partContainer != null) {
            IPartType partType = partContainer.getPart(pos.getSide());
            IPartState partState = partContainer.getPartState(pos.getSide());
            if (partType != null && partState != null) {
                return Pair.of((Object)partType, (Object)partState);
            }
        }
        return null;
    }
}

