/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockLeaves;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockMenrilSaplingConfig;
import org.cyclops.integrateddynamics.item.ItemMenrilBerriesConfig;

public class BlockMenrilLeavesConfig
extends BlockConfig {
    public static BlockMenrilLeavesConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.BLOCK, comment="A 1/x chance menril berries will be dropped when breaking a leaves block.", isCommandable=true, minimalValue=0)
    public static int berriesDropChance;

    public BlockMenrilLeavesConfig() {
        super((ModBase)IntegratedDynamics._instance, true, "menrilLeaves", null, null);
    }

    protected IConfigurable initSubInstance() {
        return (ConfigurableBlockLeaves)new ConfigurableBlockLeaves((ExtendedConfig)this){

            public Item func_180660_a(IBlockState iBlockState, Random random, int i) {
                return Item.func_150898_a((Block)BlockMenrilSaplingConfig._instance.getBlockInstance());
            }

            public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
                List drops = super.getDrops(world, pos, state, fortune);
                if (world instanceof World && !((World)world).field_72995_K && ((World)world).field_73012_v.nextInt(berriesDropChance) == 0) {
                    drops.add(new ItemStack(ItemMenrilBerriesConfig._instance.getItemInstance()));
                }
                return drops;
            }

            public SoundType func_185467_w() {
                return SoundType.field_185849_b;
            }

            @Nullable
            protected ItemStack func_180643_i(IBlockState state) {
                return new ItemStack((Block)this);
            }
        }.func_149711_c(0.2f).func_149715_a(0.65f).func_149713_g(1);
    }

    public String getOreDictionaryId() {
        return "treeLeaves";
    }

    public void onRegistered() {
        Blocks.field_150480_ab.func_180686_a(this.getBlockInstance(), 5, 20);
    }

    static {
        berriesDropChance = 4;
    }
}

