/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Objects;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class CombinedOperator
extends OperatorBase {
    private final String unlocalizedType;

    public CombinedOperator(String symbol, String operatorName, OperatorsFunction function, IValueType outputType) {
        this(symbol, operatorName, function, new IValueType[]{ValueTypes.CATEGORY_ANY}, outputType, IConfigRenderPattern.PREFIX_1);
    }

    public CombinedOperator(String symbol, String operatorName, OperatorsFunction function, IValueType[] inputTypes, IValueType outputType, IConfigRenderPattern configRenderPattern) {
        super(symbol, operatorName, inputTypes, outputType, function, configRenderPattern);
        this.unlocalizedType = "virtual";
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public static abstract class ListOperatorSerializer<F extends OperatorBase.IFunction>
    implements IOperatorSerializer<CombinedOperator> {
        private final String functionName;
        private final Class<? extends OperatorBase.IFunction> functionClass;

        public ListOperatorSerializer(String functionName, Class<? extends OperatorBase.IFunction> functionClass) {
            this.functionName = functionName;
            this.functionClass = functionClass;
        }

        @Override
        public boolean canHandle(IOperator operator) {
            return operator instanceof CombinedOperator && this.functionClass.isInstance(((CombinedOperator)operator).getFunction());
        }

        @Override
        public String getUniqueName() {
            return "combined." + this.functionName;
        }

        @Override
        public String serialize(CombinedOperator operator) {
            OperatorsFunction function = (OperatorsFunction)operator.getFunction();
            IOperator[] operators = function.getOperators();
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (IOperator functionOperator : operators) {
                list.func_74742_a((NBTBase)new NBTTagString(Operators.REGISTRY.serialize(functionOperator)));
            }
            tag.func_74782_a("operators", (NBTBase)list);
            return tag.toString();
        }

        @Override
        public CombinedOperator deserialize(String valueOperator) throws EvaluationException {
            NBTTagList list;
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)valueOperator);
                list = tag.func_150295_c("operators", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal());
            }
            catch (NBTException e) {
                e.printStackTrace();
                throw new EvaluationException(e.getMessage());
            }
            IOperator[] operators = new IOperator[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                operators[i] = Objects.requireNonNull(Operators.REGISTRY.deserialize(list.func_150307_f(i)));
            }
            return this.newFunction(operators);
        }

        public abstract CombinedOperator newFunction(IOperator ... var1) throws EvaluationException;
    }

    public static class Flip
    extends OperatorsFunction {
        public Flip(IOperator operator) {
            super(operator);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            int size = variables.getVariables().length;
            IValue[] values = new IValue[size];
            for (int i = 0; i < size; ++i) {
                values[size - i - 1] = variables.getValue(i);
            }
            return ValueHelpers.evaluateOperator(this.getOperators()[0], values);
        }

        public static CombinedOperator asOperator(IOperator operator) throws EvaluationException {
            CombinedOperator combinedOperator;
            Flip flip = new Flip(operator);
            IValueType[] originalInputTypes = operator.getInputTypes();
            IValueType[] flippedInputTypes = new IValueType[originalInputTypes.length];
            for (int i = 0; i < flippedInputTypes.length; ++i) {
                flippedInputTypes[flippedInputTypes.length - i - 1] = originalInputTypes[i];
            }
            try {
                combinedOperator = new CombinedOperator(":flip:", "flipped", flip, flippedInputTypes, operator.getOutputType(), IConfigRenderPattern.INFIX);
            }
            catch (IllegalArgumentException e) {
                throw new EvaluationException(e.getMessage());
            }
            return combinedOperator;
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("flip", Flip.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) throws EvaluationException {
                return Flip.asOperator(operators[0]);
            }
        }
    }

    public static class Pipe
    extends OperatorsFunction {
        public Pipe(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                value = ValueHelpers.evaluateOperator(operator, new IValue[]{value});
            }
            return value;
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Pipe pipe = new Pipe(operators);
            return new CombinedOperator(":.:", "piped", pipe, operators[operators.length - 1].getOutputType());
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("pipe", Pipe.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Pipe.asOperator(operators);
            }
        }
    }

    public static class Negation
    extends OperatorsFunction {
        public Negation(IOperator operator) {
            super(operator);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            IValue result = ValueHelpers.evaluateOperator(this.getOperators()[0], new IValue[]{value});
            return ValueTypeBoolean.ValueBoolean.of(!((ValueTypeBoolean.ValueBoolean)result).getRawValue());
        }

        public static CombinedOperator asOperator(IOperator operator) {
            Negation negation = new Negation(operator);
            return new CombinedOperator("!:", "p_negation", negation, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("negation", Negation.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Negation.asOperator(operators[0]);
            }
        }
    }

    public static class Disjunction
    extends OperatorsFunction {
        public Disjunction(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                IValue result = ValueHelpers.evaluateOperator(operator, new IValue[]{value});
                if (!((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(true);
            }
            return ValueTypeBoolean.ValueBoolean.of(false);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Disjunction disjunction = new Disjunction(operators);
            return new CombinedOperator(":||:", "p_disjunction", disjunction, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("disjunction", Disjunction.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Disjunction.asOperator(operators);
            }
        }
    }

    public static class Conjunction
    extends OperatorsFunction {
        public Conjunction(IOperator ... operators) {
            super(operators);
        }

        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            Object value = variables.getValue(0);
            for (IOperator operator : this.getOperators()) {
                IValue result = ValueHelpers.evaluateOperator(operator, new IValue[]{value});
                if (((ValueTypeBoolean.ValueBoolean)result).getRawValue()) continue;
                return ValueTypeBoolean.ValueBoolean.of(false);
            }
            return ValueTypeBoolean.ValueBoolean.of(true);
        }

        public static CombinedOperator asOperator(IOperator ... operators) {
            Conjunction conjunction = new Conjunction(operators);
            return new CombinedOperator(":&&:", "p_conjunction", conjunction, ValueTypes.BOOLEAN);
        }

        public static class Serializer
        extends ListOperatorSerializer<Conjunction> {
            public Serializer() {
                super("conjunction", Conjunction.class);
            }

            @Override
            public CombinedOperator newFunction(IOperator ... operators) {
                return Conjunction.asOperator(operators);
            }
        }
    }

    public static abstract class OperatorsFunction
    implements OperatorBase.IFunction {
        private final IOperator[] operators;

        public OperatorsFunction(IOperator ... operators) {
            this.operators = operators;
        }

        public IOperator[] getOperators() {
            return this.operators;
        }

        public int getInputOperatorCount() {
            return this.getOperators().length;
        }
    }
}

