/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class CableHelpers {
    @Nullable
    public static ICable getCable(IBlockAccess world, BlockPos pos) {
        return (ICable)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, CableConfig.CAPABILITY);
    }

    @Nullable
    public static ICableFakeable getCableFakeable(IBlockAccess world, BlockPos pos) {
        return (ICableFakeable)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, CableFakeableConfig.CAPABILITY);
    }

    @Nullable
    public static IPathElement getPathElement(IBlockAccess world, BlockPos pos) {
        return (IPathElement)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, PathElementConfig.CAPABILITY);
    }

    public static void updateConnectionsNeighbours(IBlockAccess world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CableHelpers.updateConnections(world, pos.func_177972_a(side));
        }
    }

    public static void updateConnections(IBlockAccess world, BlockPos pos) {
        ICable cable = CableHelpers.getCable(world, pos);
        if (cable != null) {
            cable.updateConnections();
        }
    }

    public static boolean isCableConnected(IBlockAccess world, BlockPos pos, EnumFacing side) {
        ICable cable = CableHelpers.getCable(world, pos);
        return cable != null && cable.isConnected(side);
    }

    public static boolean canCableConnectTo(IBlockAccess world, BlockPos pos, EnumFacing side, ICable originCable) {
        BlockPos neighbourPos = pos.func_177972_a(side);
        ICable neighbourCable = CableHelpers.getCable(world, neighbourPos);
        return neighbourCable != null && originCable.canConnect(neighbourCable, side) && neighbourCable.canConnect(originCable, side.func_176734_d());
    }

    public static boolean isNoFakeCable(IBlockAccess world, BlockPos pos) {
        ICableFakeable cableFakeable = CableHelpers.getCableFakeable(world, pos);
        return cableFakeable == null || cableFakeable.isRealCable();
    }

    public static boolean onCableActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack heldItem, EnumFacing side, @Nullable EnumFacing cableConnectionHit) {
        ICable cable = CableHelpers.getCable((IBlockAccess)world, pos);
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            if (world.field_72995_K) {
                return true;
            }
            if (player.func_70093_af()) {
                CableHelpers.removeCable(world, pos, player);
            } else {
                if (cableConnectionHit != null) {
                    cable.disconnect(cableConnectionHit);
                    cable.updateConnections();
                    CableHelpers.updateConnectionsNeighbours((IBlockAccess)world, pos);
                    NetworkHelpers.initNetwork(world, pos);
                    NetworkHelpers.initNetwork(world, pos.func_177972_a(cableConnectionHit));
                    return true;
                }
                if (cableConnectionHit == null) {
                    BlockPos neighbourPos = pos.func_177972_a(side);
                    ICable neighbourCable = CableHelpers.getCable((IBlockAccess)world, neighbourPos);
                    if (neighbourCable != null && !cable.isConnected(side) && (cable.canConnect(neighbourCable, side) || neighbourCable.canConnect(cable, side.func_176734_d()))) {
                        cable.reconnect(side);
                        neighbourCable.reconnect(side.func_176734_d());
                        cable.updateConnections();
                        CableHelpers.updateConnectionsNeighbours((IBlockAccess)world, pos);
                        NetworkHelpers.initNetwork(world, pos);
                        NetworkHelpers.initNetwork(world, neighbourPos);
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public static void onCableAdded(World world, BlockPos pos, @Nullable EntityLivingBase placer) {
        CableHelpers.updateConnectionsNeighbours((IBlockAccess)world, pos);
        if (!world.field_72995_K) {
            INetwork network = NetworkHelpers.initNetwork(world, pos);
            MinecraftForge.EVENT_BUS.post((Event)new NetworkInitializedEvent(network, world, pos, placer));
        }
    }

    public static boolean onCableRemoving(World world, BlockPos pos, boolean dropMainElement) {
        if (!world.field_72995_K && CableHelpers.isNoFakeCable((IBlockAccess)world, pos)) {
            INetworkCarrier networkCarrier = NetworkHelpers.getNetworkCarrier((IBlockAccess)world, pos);
            LinkedList itemStacks = Lists.newLinkedList();
            INetworkElementProvider networkElementProvider = NetworkHelpers.getNetworkElementProvider((IBlockAccess)world, pos);
            if (networkElementProvider != null) {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.addDrops(itemStacks, dropMainElement);
                }
                for (ItemStack itemStack : itemStacks) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
            if (networkCarrier != null && networkCarrier.getNetwork() != null) {
                IPathElement pathElement = CableHelpers.getPathElement((IBlockAccess)world, pos);
                INetwork network = networkCarrier.getNetwork();
                networkCarrier.setNetwork(null);
                return network.removePathElement(pathElement);
            }
        }
        return true;
    }

    public static boolean onCableRemoved(World world, BlockPos pos) {
        CableHelpers.updateConnectionsNeighbours((IBlockAccess)world, pos);
        if (!world.field_72995_K) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                BlockPos sidePos = pos.func_177972_a(side);
                NetworkHelpers.initNetwork(world, sidePos);
            }
        }
        return true;
    }

    public static void removeCable(World world, BlockPos pos, @Nullable EntityPlayer player) {
        ICable cable = CableHelpers.getCable((IBlockAccess)world, pos);
        ICableFakeable cableFakeable = CableHelpers.getCableFakeable((IBlockAccess)world, pos);
        IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos);
        IBlockState blockState = world.func_180495_p(pos);
        if (cable == null) {
            return;
        }
        CableHelpers.onCableRemoving(world, pos, false);
        if (cableFakeable == null || partContainer == null || !partContainer.hasParts()) {
            cable.destroy();
        } else {
            cableFakeable.setRealCable(false);
        }
        if (player == null) {
            ItemStackHelpers.spawnItemStack((World)world, (BlockPos)pos, (ItemStack)cable.getItemStack());
        } else if (!player.field_71075_bZ.field_75098_d) {
            ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)cable.getItemStack(), (EntityPlayer)player);
        }
        CableHelpers.onCableRemoved(world, pos);
        ItemBlockCable.playBreakSound(world, pos, blockState);
    }

    public static boolean hasFacade(IBlockAccess world, BlockPos pos) {
        IFacadeable facadeable = (IFacadeable)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY);
        return facadeable != null && facadeable.hasFacade();
    }

    @Nullable
    public static IBlockState getFacade(IBlockAccess world, BlockPos pos) {
        IFacadeable facadeable = (IFacadeable)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, null, FacadeableConfig.CAPABILITY);
        return facadeable != null ? facadeable.getFacade() : null;
    }

    public static boolean isLightTransparent(IBlockAccess world, BlockPos pos) {
        IPartContainer partContainer = PartHelpers.getPartContainer(world, pos);
        if (partContainer != null) {
            for (Map.Entry<EnumFacing, IPartType<?, ?>> entry : partContainer.getParts().entrySet()) {
                IPartType<?, ?> part = entry.getValue();
                if (!part.forceLightTransparency(partContainer.getPartState(entry.getKey()))) continue;
                return true;
            }
        }
        return false;
    }
}

