/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class EnergyHelpers {
    private static final List<IEnergyStorageProxy> ENERGY_STORAGE_PROXIES = Lists.newArrayList();

    public static void addEnergyStorageProxy(IEnergyStorageProxy energyStorageProxy) {
        ENERGY_STORAGE_PROXIES.add(energyStorageProxy);
    }

    public static IEnergyStorage getEnergyStorage(PartPos pos) {
        return EnergyHelpers.getEnergyStorage(pos.getPos(), pos.getSide());
    }

    public static IEnergyStorage getEnergyStorage(DimPos pos, EnumFacing facing) {
        World world = pos.getWorld();
        return world != null ? EnergyHelpers.getEnergyStorage((IBlockAccess)world, pos.getBlockPos(), facing) : null;
    }

    public static IEnergyStorage getEnergyStorage(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IEnergyStorage energyStorage = (IEnergyStorage)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)facing, (Capability)CapabilityEnergy.ENERGY);
        if (energyStorage == null) {
            for (IEnergyStorageProxy energyStorageProxy : ENERGY_STORAGE_PROXIES) {
                energyStorage = energyStorageProxy.getEnergyStorageProxy(world, pos, facing);
                if (energyStorage == null) continue;
                return energyStorage;
            }
        }
        return energyStorage;
    }

    public static int fillNeigbours(World world, BlockPos pos, int energy, boolean simulate) {
        int toFill = energy;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IEnergyStorage energyStorage = EnergyHelpers.getEnergyStorage((IBlockAccess)world, pos.func_177972_a(side), side.func_176734_d());
            if (energyStorage == null || (toFill -= energyStorage.receiveEnergy(toFill, simulate)) > 0) continue;
            return energy;
        }
        return energy - toFill;
    }

    public static interface IEnergyStorageProxy {
        @Nullable
        public IEnergyStorage getEnergyStorageProxy(IBlockAccess var1, BlockPos var2, EnumFacing var3);
    }
}

