/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.capability.energystorage.EnergyStorageItemBlockEnergyContainer;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI", striprefs=true)
public class ItemBlockEnergyContainer
extends ItemBlockNBT
implements IEnergyContainerItem {
    private IEnergyContainerBlock block;

    public ItemBlockEnergyContainer(Block block) {
        super(block);
        this.func_77627_a(false);
        this.block = (IEnergyContainerBlock)block;
    }

    public IEnergyContainerBlock get() {
        return this.block;
    }

    protected IEnergyStorage getEnergyBattery(ItemStack itemStack) {
        return (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        IEnergyStorage energyStorage = this.getEnergyBattery(itemStack);
        int amount = energyStorage.getEnergyStored();
        int capacity = energyStorage.getMaxEnergyStored();
        String line = String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energyUnit.name");
        list.add(IInformationProvider.ITEM_PREFIX + line);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        IEnergyStorage energyStorage = this.getEnergyBattery(itemStack);
        double amount = energyStorage.getEnergyStored();
        double capacity = energyStorage.getMaxEnergyStored();
        return (capacity - amount) / capacity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new DefaultCapabilityProvider(CapabilityEnergy.ENERGY, (Object)new EnergyStorageItemBlockEnergyContainer(this, stack));
    }

    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return this.getEnergyBattery(container).receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return this.getEnergyBattery(container).extractEnergy(maxExtract, simulate);
    }

    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ItemStack container) {
        return this.getEnergyBattery(container).getEnergyStored();
    }

    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ItemStack container) {
        return this.getEnergyBattery(container).getMaxEnergyStored();
    }
}

