/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public abstract class VariableFacadeBase
implements IVariableFacade {
    private final int id;

    public VariableFacadeBase(boolean generateId) {
        this.id = generateId ? VariableFacadeBase.generateId() : -1;
    }

    public VariableFacadeBase(int id) {
        this.id = id;
    }

    public static int generateId() {
        return IntegratedDynamics.globalCounters.getNext("variable");
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(this.getId());
    }

    protected String getReferenceDisplay(int variableId) {
        String label = LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(variableId);
        if (label == null) {
            return String.valueOf(variableId);
        }
        return String.format("%s:%s", label, variableId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> list, EntityPlayer entityPlayer) {
        list.add(L10NHelpers.localize((String)"item.items.integrateddynamics.variable.id", (Object[])new Object[]{this.getId() == -1 ? "..." : Integer.valueOf(this.getId())}));
    }
}

