/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.panel;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.client.gui.GuiPartDisplay;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.PartStateActiveVariableBase;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanel;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartDisplay;

public abstract class PartTypePanelVariableDriven<P extends PartTypePanelVariableDriven<P, S>, S extends State<P, S>>
extends PartTypePanel<P, S> {
    public PartTypePanelVariableDriven(String name) {
        super(name);
    }

    @Override
    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlockStatus((ExtendedConfig)blockConfig);
    }

    @Override
    protected Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> constructNetworkEventActions() {
        Map<Class<? extends INetworkEvent>, PartTypeBase.IEventAction> actions = super.constructNetworkEventActions();
        actions.put(VariableContentsUpdatedEvent.class, new PartTypeBase.IEventAction<P, S, VariableContentsUpdatedEvent>(){

            @Override
            public void onAction(INetwork network, PartTarget target, S state, VariableContentsUpdatedEvent event) {
                IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
                PartTypePanelVariableDriven.this.onVariableContentsUpdated(partNetwork, target, state);
            }
        });
        actions.put(NetworkElementAddEvent.Post.class, new PartTypeBase.IEventAction<P, S, NetworkElementAddEvent.Post>(){

            @Override
            public void onAction(INetwork network, PartTarget target, S state, NetworkElementAddEvent.Post event) {
                IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
                PartTypePanelVariableDriven.this.onVariableContentsUpdated(partNetwork, target, state);
            }
        });
        return actions;
    }

    @Override
    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement) {
        for (int i = 0; i < ((PartStateActiveVariableBase)state).getInventory().func_70302_i_(); ++i) {
            ItemStack itemStack = ((PartStateActiveVariableBase)state).getInventory().func_70301_a(i);
            if (itemStack == null) continue;
            itemStacks.add(itemStack);
        }
        ((PartStateActiveVariableBase)state).getInventory().func_174888_l();
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
        super.addDrops(target, state, itemStacks, dropMainElement);
    }

    @Override
    public void beforeNetworkKill(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.beforeNetworkKill(network, partNetwork, target, state);
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public void afterNetworkAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkAlive(network, partNetwork, target, state);
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public boolean isUpdate(S state) {
        return true;
    }

    @Override
    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.update(network, partNetwork, target, state);
        IValue lastValue = ((State)state).getDisplayValue();
        IValue newValue = null;
        if (((PartStateActiveVariableBase)state).hasVariable()) {
            try {
                IVariable variable = ((PartStateActiveVariableBase)state).getVariable(partNetwork);
                if (variable != null) {
                    newValue = (IValue)variable.getValue();
                }
            }
            catch (EvaluationException e) {
                ((PartStateActiveVariableBase)state).addGlobalError(new L10NHelpers.UnlocalizedString(e.getLocalizedMessage(), new Object[0]));
            }
        }
        if (!ValueHelpers.areValuesEqual(lastValue, newValue)) {
            this.onValueChanged(network, partNetwork, target, state, lastValue, newValue);
            ((PartStateBase)state).onDirty();
            BlockHelpers.markForUpdate((World)target.getCenter().getPos().getWorld(), (BlockPos)target.getCenter().getPos().getBlockPos());
        }
    }

    protected void onValueChanged(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, IValue lastValue, IValue newValue) {
        if (newValue == null) {
            ((State)state).setDisplayValue(null);
        } else {
            IValue materializedValue = null;
            try {
                materializedValue = newValue.getType().materialize(newValue);
            }
            catch (EvaluationException e) {
                ((PartStateActiveVariableBase)state).addGlobalError(new L10NHelpers.UnlocalizedString(e.getLocalizedMessage(), new Object[0]));
            }
            ((State)state).setDisplayValue(materializedValue);
        }
    }

    @Override
    protected boolean hasGui() {
        return true;
    }

    public Class<? extends Container> getContainer() {
        return ContainerPartDisplay.class;
    }

    public Class<? extends GuiScreen> getGui() {
        return GuiPartDisplay.class;
    }

    protected IgnoredBlockStatus.Status getStatus(State state) {
        IgnoredBlockStatus.Status status = IgnoredBlockStatus.Status.INACTIVE;
        if (state != null && !state.getInventory().isEmpty()) {
            status = state.hasVariable() && state.isEnabled() ? IgnoredBlockStatus.Status.ACTIVE : IgnoredBlockStatus.Status.ERROR;
        }
        return status;
    }

    @Override
    public IBlockState getBlockState(IPartContainer partContainer, EnumFacing side) {
        IgnoredBlockStatus.Status status = this.getStatus(partContainer != null ? (State)partContainer.getPartState(side) : null);
        return this.getBlock().func_176223_P().func_177226_a((IProperty)IgnoredBlock.FACING, (Comparable)side).func_177226_a((IProperty)IgnoredBlockStatus.STATUS, (Comparable)((Object)status));
    }

    protected void onVariableContentsUpdated(IPartNetwork network, PartTarget target, S state) {
        ((PartStateActiveVariableBase)state).onVariableContentsUpdated((PartTypePanelVariableDriven)this, target);
    }

    @Override
    public boolean onPartActivated(World world, BlockPos pos, final S partState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            WrenchHelpers.wrench(player, heldItem, world, pos, side, new WrenchHelpers.IWrenchAction<Void>(){

                @Override
                public void onWrench(EntityPlayer player, BlockPos pos, Void parameter) {
                    partState.setFacingRotation(partState.getFacingRotation().func_176732_a(EnumFacing.Axis.Y));
                }
            });
            return true;
        }
        return super.onPartActivated(world, pos, partState, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public void loadTooltip(S state, List<String> lines) {
        if (!((PartStateActiveVariableBase)state).getInventory().isEmpty()) {
            if (((PartStateActiveVariableBase)state).hasVariable() && ((PartStateBase)state).isEnabled()) {
                IValue value = ((State)state).getDisplayValue();
                if (value != null) {
                    IValueType valueType = value.getType();
                    lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.display.activeValue", (Object[])new Object[]{valueType.getDisplayColorFormat() + valueType.toCompactString(value), L10NHelpers.localize((String)valueType.getUnlocalizedName())}));
                }
            } else {
                lines.add(TextFormatting.RED + L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.errors"));
                for (L10NHelpers.UnlocalizedString error : ((PartStateActiveVariableBase)state).getGlobalErrors()) {
                    lines.add(TextFormatting.RED + error.localize());
                }
            }
        } else {
            lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.inactive"));
        }
        super.loadTooltip(state, lines);
    }

    @Override
    public boolean shouldTriggerBlockRenderUpdate(@Nullable S oldPartState, @Nullable S newPartState) {
        return super.shouldTriggerBlockRenderUpdate(oldPartState, newPartState) || this.getStatus((State)oldPartState) != this.getStatus((State)newPartState);
    }

    public static abstract class State<P extends PartTypePanelVariableDriven<P, S>, S extends State<P, S>>
    extends PartStateActiveVariableBase<P> {
        private IValue displayValue;
        private EnumFacing facingRotation = EnumFacing.NORTH;

        public State() {
            super(1);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            super.writeToNBT(tag);
            IValue value = this.getDisplayValue();
            if (value != null) {
                tag.func_74778_a("displayValueType", value.getType().getUnlocalizedName());
                tag.func_74778_a("displayValue", value.getType().serialize(value));
            }
            tag.func_74768_a("facingRotation", this.facingRotation.ordinal());
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            super.readFromNBT(tag);
            if (tag.func_150297_b("displayValueType", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal()) && tag.func_150297_b("displayValue", MinecraftHelpers.NBTTag_Types.NBTTagString.ordinal())) {
                IValueType valueType = ValueTypes.REGISTRY.getValueType(tag.func_74779_i("displayValueType"));
                if (valueType != null) {
                    String serializedValue = tag.func_74779_i("displayValue");
                    L10NHelpers.UnlocalizedString deserializationError = valueType.canDeserialize(serializedValue);
                    if (deserializationError == null) {
                        this.setDisplayValue((IValue)valueType.deserialize(serializedValue));
                    } else {
                        IntegratedDynamics.clog(Level.ERROR, deserializationError.localize());
                    }
                } else {
                    IntegratedDynamics.clog(Level.ERROR, String.format("Tried to deserialize the value \"%s\" for type \"%s\" which could not be found.", tag.func_74779_i("displayValueType"), tag.func_74779_i("value")));
                }
            } else {
                this.setDisplayValue(null);
            }
            this.facingRotation = EnumFacing.values()[Math.max(2, tag.func_74762_e("facingRotation"))];
        }

        public IValue getDisplayValue() {
            return this.displayValue;
        }

        public void setDisplayValue(IValue displayValue) {
            this.displayValue = displayValue;
        }

        public EnumFacing getFacingRotation() {
            return this.facingRotation;
        }

        public void setFacingRotation(EnumFacing facingRotation) {
            this.facingRotation = facingRotation;
        }
    }
}

