/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.base.Optional;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.cyclops.cyclopscore.block.property.ExtendedBlockStateBuilder;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableMultipartTicking;
import org.cyclops.integrateddynamics.capability.cable.CableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderPartContainer;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.client.model.CableRenderState;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class TileMultipartTicking
extends CyclopsTileEntity
implements CyclopsTileEntity.ITickingTile,
PartHelpers.IPartStateHolderCallback {
    protected final CyclopsTileEntity.ITickingTile tickingTileComponent = new CyclopsTileEntity.TickingTileComponent((CyclopsTileEntity)this);
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> redstoneLevels = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneInputs = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneStrong = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lightLevels = EnumFacingMap.newMap();
    private EnumFacingMap<Integer> previousLightLevels;
    @NBTPersist
    private String facadeBlockName = null;
    @NBTPersist
    private int facadeMeta = 0;
    private final PartContainerTileMultipartTicking partContainer = new PartContainerTileMultipartTicking(this);
    private final CableTileMultipartTicking cable;
    private final INetworkCarrier networkCarrier;
    private final ICableFakeable cableFakeable;
    private IExtendedBlockState cachedState = null;

    public TileMultipartTicking() {
        this.addCapabilityInternal(PartContainerConfig.CAPABILITY, this.partContainer);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderPartContainer(this.partContainer));
        this.addCapabilityInternal(FacadeableConfig.CAPABILITY, new FacadeableTileMultipartTicking(this));
        this.cable = new CableTileMultipartTicking(this);
        this.addCapabilityInternal(CableConfig.CAPABILITY, this.cable);
        this.networkCarrier = new NetworkCarrierDefault();
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, this.networkCarrier);
        this.cableFakeable = new CableFakeableMultipartTicking(this);
        this.addCapabilityInternal(CableFakeableConfig.CAPABILITY, this.cableFakeable);
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, new PathElementTile((TileEntity)this, this.cable));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addCapabilitySided(DynamicLightConfig.CAPABILITY, facing, new DynamicLightTileMultipartTicking(this, facing));
            this.addCapabilitySided(DynamicRedstoneConfig.CAPABILITY, facing, new DynamicRedstoneTileMultipartTicking(this, facing));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("partContainer", (NBTBase)this.partContainer.serializeNBT());
        tag.func_74757_a("realCable", this.cableFakeable.isRealCable());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        boolean isLightTransparent;
        EnumFacingMap lastConnected = EnumFacingMap.newMap(this.connected);
        String lastFacadeBlockName = this.facadeBlockName;
        int lastFacadeMeta = this.facadeMeta;
        boolean lastRealCable = this.cableFakeable.isRealCable();
        if (tag.func_150297_b("parts", MinecraftHelpers.NBTTag_Types.NBTTagList.ordinal()) && !tag.func_150297_b("partContainer", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal())) {
            PartHelpers.readPartsFromNBT(this.getNetwork(), this.func_174877_v(), tag, this.partContainer.getPartData(), this.func_145831_w());
        } else {
            this.partContainer.deserializeNBT(tag.func_74775_l("partContainer"));
        }
        boolean wasLightTransparent = this.func_145831_w() != null && CableHelpers.isLightTransparent((IBlockAccess)this.func_145831_w(), this.func_174877_v());
        super.func_145839_a(tag);
        this.cableFakeable.setRealCable(tag.func_74767_n("realCable"));
        boolean bl = isLightTransparent = this.func_145831_w() != null && CableHelpers.isLightTransparent((IBlockAccess)this.func_145831_w(), this.func_174877_v());
        if (!(this.func_145831_w() == null || lastConnected != null && this.connected != null && lastConnected.equals(this.connected) && Objects.equals(lastFacadeBlockName, this.facadeBlockName) && lastFacadeMeta == this.facadeMeta && lastRealCable == this.cableFakeable.isRealCable() && wasLightTransparent == isLightTransparent)) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
            this.func_145831_w().func_175664_x(this.func_174877_v());
        }
    }

    public void onUpdateReceived() {
        if (!this.lightLevels.equals(this.previousLightLevels)) {
            this.previousLightLevels = this.lightLevels;
            this.func_145831_w().func_175664_x(this.func_174877_v());
        }
        this.cachedState = null;
    }

    public IExtendedBlockState getConnectionState() {
        if (this.cachedState != null) {
            return this.cachedState;
        }
        ExtendedBlockStateBuilder builder = ExtendedBlockStateBuilder.builder((IExtendedBlockState)((IExtendedBlockState)this.getBlock().func_176223_P()));
        if (this.partContainer.getPartData() != null) {
            builder.withProperty(BlockCable.REALCABLE, (Object)this.cableFakeable.isRealCable());
            if (this.connected.isEmpty()) {
                this.getCable().updateConnections();
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                builder.withProperty(BlockCable.CONNECTED[side.ordinal()], (Object)(!this.cable.isForceDisconnected(side) && (Boolean)this.connected.get((Object)side) != false ? 1 : 0));
                builder.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)(this.partContainer.hasPart(side) ? this.partContainer.getPart(side).getPartRenderPosition() : PartRenderPosition.NONE));
            }
            IFacadeable facadeable = this.getCapability(FacadeableConfig.CAPABILITY, null);
            builder.withProperty(BlockCable.FACADE, (Object)(facadeable.hasFacade() ? Optional.of((Object)facadeable.getFacade()) : Optional.absent()));
            builder.withProperty(BlockCable.PARTCONTAINER, (Object)this.partContainer);
            builder.withProperty(BlockCable.RENDERSTATE, (Object)new CableRenderState(this.cableFakeable.isRealCable(), (EnumFacingMap<Boolean>)EnumFacingMap.newMap(this.connected), EnumFacingMap.newMap(this.partContainer.getPartData()), this.facadeBlockName, this.facadeMeta));
        }
        this.cachedState = builder.build();
        return this.cachedState;
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.connected.isEmpty()) {
            this.cable.updateConnections();
        }
        this.partContainer.update();
    }

    public void updateRedstoneInfo(EnumFacing side) {
        if (this.func_145831_w().func_175667_e(this.func_174877_v().func_177972_a(side))) {
            this.func_145831_w().func_180496_d(this.func_174877_v().func_177972_a(side), this.func_145838_q());
        }
    }

    public void updateLightInfo() {
        this.sendUpdate();
    }

    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    @Override
    public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public void setForceDisconnected(EnumFacingMap<Boolean> forceDisconnected) {
        this.forceDisconnected.clear();
        this.forceDisconnected.putAll(forceDisconnected);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) || this.partContainer.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object value = super.getCapability(capability, facing);
        if (value != null) {
            return (T)value;
        }
        return this.partContainer.getCapability(capability, facing);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.invalidateParts();
    }

    protected void invalidateParts() {
        INetwork network;
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K && (network = this.getNetwork()) != null) {
            for (Map.Entry entry : this.partContainer.getPartData().entrySet()) {
                INetworkElement element = ((PartHelpers.PartStateHolder)entry.getValue()).getPart().createNetworkElement(this.getPartContainer(), DimPos.of((World)this.func_145831_w(), (BlockPos)this.func_174877_v()), (EnumFacing)entry.getKey());
                element.invalidate(network);
            }
        }
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public EnumFacingMap<Integer> getRedstoneLevels() {
        return this.redstoneLevels;
    }

    public EnumFacingMap<Boolean> getRedstoneInputs() {
        return this.redstoneInputs;
    }

    public EnumFacingMap<Boolean> getRedstoneStrong() {
        return this.redstoneStrong;
    }

    public EnumFacingMap<Integer> getLightLevels() {
        return this.lightLevels;
    }

    public String getFacadeBlockName() {
        return this.facadeBlockName;
    }

    public void setFacadeBlockName(String facadeBlockName) {
        this.facadeBlockName = facadeBlockName;
    }

    public int getFacadeMeta() {
        return this.facadeMeta;
    }

    public void setFacadeMeta(int facadeMeta) {
        this.facadeMeta = facadeMeta;
    }

    public PartContainerTileMultipartTicking getPartContainer() {
        return this.partContainer;
    }

    public CableTileMultipartTicking getCable() {
        return this.cable;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public ICableFakeable getCableFakeable() {
        return this.cableFakeable;
    }

    public void func_73660_a() {
        this.tickingTileComponent.func_73660_a();
    }
}

