/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.DurationRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.ItemAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.block.BlockDryingBasin;
import org.cyclops.integrateddynamics.block.BlockDryingBasinConfig;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.block.BlockSqueezerConfig;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.infobook.pageelement.AspectAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.DryingBasinRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.OperatorAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.SqueezerRecipeAppendix;
import org.cyclops.integrateddynamics.part.aspect.Aspects;
import org.w3c.dom.Element;

public class OnTheDynamicsOfIntegrationBook
extends InfoBook {
    private static OnTheDynamicsOfIntegrationBook _instance = null;

    private OnTheDynamicsOfIntegrationBook() {
        super((ModBase)IntegratedDynamics._instance, 2);
    }

    public static OnTheDynamicsOfIntegrationBook getInstance() {
        if (_instance == null) {
            _instance = new OnTheDynamicsOfIntegrationBook();
        }
        return _instance;
    }

    static {
        if (ConfigHandler.isEnabled(BlockSqueezerConfig.class)) {
            InfoBookParser.registerFactory((String)"integrateddynamics:squeezerRecipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    FluidStack fluidStack;
                    ItemStack itemStack;
                    try {
                        itemStack = InfoBookParser.createStack((Element)((Element)node.getElementsByTagName("item").item(0)), (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    }
                    catch (InfoBookParser.InvalidAppendixException e) {
                        itemStack = null;
                    }
                    try {
                        fluidStack = InfoBookParser.createFluidStack((Element)((Element)node.getElementsByTagName("fluid").item(0)), (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    }
                    catch (InfoBookParser.InvalidAppendixException e) {
                        fluidStack = null;
                    }
                    List recipes = BlockSqueezer.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new ItemAndFluidStackRecipeComponent(itemStack, fluidStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find Squeezer recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new SqueezerRecipeAppendix(infoBook, (IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent>)((IRecipe)recipes.get(index)));
                }
            });
            InfoBookParser.registerFactory((String)"integrateddynamics:squeezerRecipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new SqueezerRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"integrateddynamics:squeezerRecipe");
        }
        if (ConfigHandler.isEnabled(BlockDryingBasinConfig.class)) {
            InfoBookParser.registerFactory((String)"integrateddynamics:dryingBasinRecipe", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

                public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                    FluidStack fluidStack;
                    ItemStack itemStack;
                    try {
                        itemStack = InfoBookParser.createStack((Element)((Element)node.getElementsByTagName("item").item(0)), (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    }
                    catch (InfoBookParser.InvalidAppendixException e) {
                        itemStack = null;
                    }
                    try {
                        fluidStack = InfoBookParser.createFluidStack((Element)((Element)node.getElementsByTagName("fluid").item(0)), (RecipeHandler)infoBook.getMod().getRecipeHandler());
                    }
                    catch (InfoBookParser.InvalidAppendixException e) {
                        fluidStack = null;
                    }
                    List recipes = BlockDryingBasin.getInstance().getRecipeRegistry().findRecipesByOutput((IRecipeOutput)new ItemAndFluidStackRecipeComponent(itemStack, fluidStack));
                    int index = InfoBookParser.getIndex((Element)node);
                    if (index >= recipes.size()) {
                        throw new InfoBookParser.InvalidAppendixException("Could not find Drying Basin recipe for " + itemStack.func_77973_b().func_77658_a() + "with index " + index);
                    }
                    return new DryingBasinRecipeAppendix(infoBook, (IRecipe<ItemAndFluidStackRecipeComponent, ItemAndFluidStackRecipeComponent, DurationRecipeProperties>)((IRecipe)recipes.get(index)));
                }
            });
            InfoBookParser.registerFactory((String)"integrateddynamics:dryingBasinRecipe", (InfoBookParser.IAppendixItemFactory)new InfoBookParser.IAppendixItemFactory<ItemAndFluidStackRecipeComponent, ItemAndFluidStackRecipeComponent, DurationRecipeProperties>(){

                public SectionAppendix create(IInfoBook infoBook, IRecipe<ItemAndFluidStackRecipeComponent, ItemAndFluidStackRecipeComponent, DurationRecipeProperties> recipe) throws InfoBookParser.InvalidAppendixException {
                    return new DryingBasinRecipeAppendix(infoBook, recipe);
                }
            });
        } else {
            InfoBookParser.registerIgnoredFactory((String)"integrateddynamics:dryingBasinRecipe");
        }
        InfoBookParser.registerFactory((String)"integrateddynamics:aspect", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String aspectName = node.getTextContent();
                IAspect aspect = Aspects.REGISTRY.getAspect(aspectName);
                if (aspect == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find an aspect by name %s.", aspectName));
                }
                return new AspectAppendix(infoBook, aspect);
            }
        });
        InfoBookParser.registerFactory((String)"integrateddynamics:part_aspects", (InfoBookParser.IAppendixListFactory)new InfoBookParser.IAppendixListFactory(){

            public List<SectionAppendix> create(final IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String partName = node.getTextContent();
                IPartType partType = PartTypes.REGISTRY.getPartType(partName);
                if (partType == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find a part type by name '%s'.", partName));
                }
                ArrayList aspects = Lists.newArrayList(Aspects.REGISTRY.getAspects(partType));
                return Lists.transform((List)aspects, (Function)new Function<IAspect, SectionAppendix>(){

                    @Nullable
                    public SectionAppendix apply(IAspect input) {
                        return new AspectAppendix(infoBook, input);
                    }
                });
            }
        });
        InfoBookParser.registerFactory((String)"integrateddynamics:operator", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String operatorName = node.getTextContent();
                IOperator operator = Operators.REGISTRY.getOperator(operatorName);
                if (operator == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find an operator by name %s.", operator));
                }
                return new OperatorAppendix(infoBook, operator);
            }
        });
        InfoBookParser.registerFactory((String)"integrateddynamics:operators_output", (InfoBookParser.IAppendixListFactory)new InfoBookParser.IAppendixListFactory(){

            public List<SectionAppendix> create(final IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String categoryName = node.getTextContent();
                ArrayList operators = Lists.newArrayList("*".equals(categoryName) ? Operators.REGISTRY.getOperators() : Operators.REGISTRY.getOperatorsInCategory(categoryName));
                return Lists.transform((List)operators, (Function)new Function<IOperator, SectionAppendix>(){

                    @Nullable
                    public SectionAppendix apply(IOperator input) {
                        return new OperatorAppendix(infoBook, input);
                    }
                });
            }
        });
    }
}

