/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.inventory.slot.SlotSingleItem;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.Achievements;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;
import org.cyclops.integrateddynamics.item.ItemVariable;

public abstract class ContainerLogicProgrammerBase
extends ScrollingInventoryContainer<ILogicProgrammerElement>
implements IDirtyMarkListener {
    public static final int OUTPUT_X = 232;
    public static final int OUTPUT_Y = 110;
    protected static final ScrollingInventoryContainer.IItemPredicate<ILogicProgrammerElement> FILTERER = new ScrollingInventoryContainer.IItemPredicate<ILogicProgrammerElement>(){

        public boolean apply(ILogicProgrammerElement item, Pattern pattern) {
            return pattern.matcher(item.getMatchString()).matches() || pattern.matcher(item.getSymbol()).matches();
        }
    };
    private final SimpleInventory writeSlot = new SimpleInventory(1, "writeSlot", 1);
    private final SimpleInventory filterSlots = new SimpleInventory(3, "filterSlots", 1);
    private ILogicProgrammerElement activeElement = null;
    private ILogicProgrammerElement temporarySlotsElement = null;
    private SimpleInventory temporaryInputSlots = null;
    private L10NHelpers.UnlocalizedString lastError;
    private LoadConfigListener loadConfigListener;
    private IValueType filterIn1 = null;
    private IValueType filterIn2 = null;
    private IValueType filterOut = null;
    @SideOnly(value=Side.CLIENT)
    private GuiLogicProgrammerBase gui;
    private String lastLabel = "";

    public ContainerLogicProgrammerBase(InventoryPlayer inventory, IGuiContainerProvider guiProvider) {
        super(inventory, guiProvider, ContainerLogicProgrammerBase.getElements(), FILTERER);
        this.filterSlots.addDirtyMarkListener((IDirtyMarkListener)new FilterSlotListener());
        this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
        this.loadConfigListener = new LoadConfigListener();
        this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this.loadConfigListener);
        this.temporaryInputSlots = new SimpleInventory(0, "temporaryInput", 1);
        this.initializeSlots();
        inventory.field_70458_d.func_71029_a((StatBase)Achievements.LOGIC_PROGRAMMING);
    }

    protected static List<ILogicProgrammerElement> getElements() {
        LinkedList elements = Lists.newLinkedList();
        for (ILogicProgrammerElementType type : LogicProgrammerElementTypes.REGISTRY.getTypes()) {
            elements.addAll(type.createElements());
        }
        return elements;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGui(GuiLogicProgrammerBase gui) {
        this.gui = gui;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiLogicProgrammerBase getGui() {
        return this.gui;
    }

    protected void initializeSlots() {
        this.func_75146_a((Slot)new SlotSingleItem((IInventory)this.writeSlot, 0, 232, 110, (Item)ItemVariable.getInstance()));
        SlotSingleItem filterSlotIn1 = new SlotSingleItem((IInventory)this.filterSlots, 0, 6, 218, (Item)ItemVariable.getInstance());
        SlotSingleItem filterSlotIn2 = new SlotSingleItem((IInventory)this.filterSlots, 1, 24, 218, (Item)ItemVariable.getInstance());
        SlotSingleItem filterSlotOut = new SlotSingleItem((IInventory)this.filterSlots, 2, 58, 218, (Item)ItemVariable.getInstance());
        filterSlotIn1.setPhantom(true);
        filterSlotIn2.setPhantom(true);
        filterSlotOut.setPhantom(true);
        this.func_75146_a((Slot)filterSlotIn1);
        this.func_75146_a((Slot)filterSlotIn2);
        this.func_75146_a((Slot)filterSlotOut);
        this.addPlayerInventory((InventoryPlayer)this.getPlayerIInventory(), 88, 131);
    }

    public int getPageSize() {
        return 10;
    }

    protected int getSizeInventory() {
        return 1;
    }

    public void setActiveElementById(String typeId, String elementId) {
        ILogicProgrammerElementType type = LogicProgrammerElementTypes.REGISTRY.getType(typeId);
        if (type != null) {
            Object element = type.getByName(elementId);
            if (!LogicProgrammerElementTypes.areEqual(this.getActiveElement(), element)) {
                this.setActiveElement((ILogicProgrammerElement)element, 0, 0);
                this.onDirty();
            }
        } else {
            this.setActiveElement(null, 0, 0);
        }
    }

    public void setActiveElement(ILogicProgrammerElement activeElement, int baseX, int baseY) {
        if (this.activeElement != null) {
            this.activeElement.deactivate();
        }
        this.activeElement = activeElement;
        this.lastError = null;
        this.activeElement = activeElement;
        this.setElementInventory(this.activeElement, baseX, baseY);
        if (activeElement != null) {
            activeElement.activate();
        }
    }

    public void setElementInventory(final ILogicProgrammerElement element, int baseX, int baseY) {
        this.lastError = null;
        this.field_75153_a = Lists.newArrayList();
        this.field_75151_b = Lists.newArrayList();
        this.initializeSlots();
        this.temporaryInputSlots.removeDirtyMarkListener((IDirtyMarkListener)this);
        this.temporaryInputSlots = new SimpleInventory(element == null ? 0 : element.getRenderPattern().getSlotPositions().length, "temporaryInput", 1);
        this.temporaryInputSlots.addDirtyMarkListener((IDirtyMarkListener)this);
        this.temporarySlotsElement = element;
        if (element != null) {
            Pair<Integer, Integer>[] slotPositions = element.getRenderPattern().getSlotPositions();
            for (int i = 0; i < this.temporaryInputSlots.func_70302_i_(); ++i) {
                final int slotId = i;
                SlotExtended slot = new SlotExtended((IInventory)this.temporaryInputSlots, i, 1 + baseX + (Integer)slotPositions[i].getLeft(), 1 + baseY + (Integer)slotPositions[i].getRight()){

                    public boolean func_75214_a(ItemStack itemStack) {
                        return element.isItemValidForSlot(slotId, itemStack);
                    }
                };
                slot.setPhantom(true);
                this.func_75146_a((Slot)slot);
            }
        }
        this.lastLabel = "";
    }

    public boolean canWriteActiveElementPre() {
        if (this.activeElement != null) {
            return this.activeElement.canWriteElementPre();
        }
        return false;
    }

    public boolean canWriteActiveElement() {
        if (!this.canWriteActiveElementPre()) {
            return false;
        }
        this.lastError = this.activeElement.validate();
        return this.lastError == null;
    }

    public ILogicProgrammerElement getActiveElement() {
        return this.activeElement;
    }

    public void func_75134_a(EntityPlayer player) {
        ItemStack itemStack;
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K && (itemStack = this.writeSlot.func_70301_a(0)) != null) {
            player.func_71019_a(itemStack, false);
        }
    }

    public void onLabelPacket(String label) {
        this.lastLabel = label;
        this.labelCurrent();
    }

    protected void labelCurrent() {
        IVariableFacade variableFacade;
        ItemStack itemStack = this.writeSlot.func_70301_a(0);
        if (itemStack != null && (variableFacade = ItemVariable.getInstance().getVariableFacade(itemStack)).isValid()) {
            LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).put(variableFacade.getId(), this.lastLabel);
        }
    }

    protected ItemStack writeElementInfo() {
        ItemStack itemStack = this.writeSlot.func_70301_a(0);
        ItemStack result = this.getActiveElement().writeElement(this.player, itemStack.func_77946_l());
        return result;
    }

    public void onDirty() {
        ILogicProgrammerElement activeElement = this.getActiveElement();
        if (activeElement != null) {
            for (int i = 0; i < this.temporaryInputSlots.func_70302_i_(); ++i) {
                ItemStack itemStack = this.temporaryInputSlots.func_70301_a(i);
                this.temporarySlotsElement.onInputSlotUpdated(i, itemStack);
            }
        }
        ItemStack itemStack = this.writeSlot.func_70301_a(0);
        if (this.canWriteActiveElement() && itemStack != null) {
            ItemStack outputStack = this.writeElementInfo();
            this.writeSlot.removeDirtyMarkListener((IDirtyMarkListener)this);
            this.writeSlot.func_70299_a(0, outputStack);
            if (!StringUtils.func_151246_b((String)this.lastLabel)) {
                this.labelCurrent();
            }
            this.writeSlot.addDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    protected void loadConfigFrom(ItemStack itemStack) {
        if (MinecraftHelpers.isClientSide()) {
            IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            IVariableFacade variableFacade = registry.handle(itemStack);
            for (ILogicProgrammerElement element : ContainerLogicProgrammerBase.getElements()) {
                if (!element.isFor(variableFacade)) continue;
                this.getGui().handleElementActivation(element);
            }
        }
    }

    public L10NHelpers.UnlocalizedString getLastError() {
        return this.lastError;
    }

    public IInventory getTemporaryInputSlots() {
        return this.temporaryInputSlots;
    }

    public boolean hasWriteItemInSlot() {
        return this.writeSlot.func_70301_a(0) != null;
    }

    protected boolean additionalApplies(ILogicProgrammerElement item) {
        return !((this.filterIn1 != null && !item.matchesInput(this.filterIn1) || this.filterIn2 != null && !item.matchesInput(this.filterIn2)) && (this.filterIn1 != null || this.filterIn2 != null) || this.filterOut != null && !item.matchesOutput(this.filterOut));
    }

    public ItemStack func_184996_a(int slotId, int arg, ClickType clickType, EntityPlayer player) {
        if (slotId >= this.field_75151_b.size()) {
            return null;
        }
        return super.func_184996_a(slotId, arg, clickType, player);
    }

    protected class FilterSlotListener
    implements IDirtyMarkListener {
        protected FilterSlotListener() {
        }

        protected IValueType getValueType(IInventory inventory, int slot) {
            IVariableFacade variableFacade;
            IVariableFacadeHandlerRegistry handler = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            if (inventory.func_70301_a(slot) != null && (variableFacade = handler.handle(inventory.func_70301_a(slot))).isValid()) {
                return variableFacade.getOutputType();
            }
            return null;
        }

        public void onDirty() {
            ContainerLogicProgrammerBase.this.filterIn1 = this.getValueType((IInventory)ContainerLogicProgrammerBase.this.filterSlots, 0);
            ContainerLogicProgrammerBase.this.filterIn2 = this.getValueType((IInventory)ContainerLogicProgrammerBase.this.filterSlots, 1);
            ContainerLogicProgrammerBase.this.filterOut = this.getValueType((IInventory)ContainerLogicProgrammerBase.this.filterSlots, 2);
            ContainerLogicProgrammerBase.this.refreshFilter();
        }
    }

    protected class LoadConfigListener
    implements IDirtyMarkListener {
        protected LoadConfigListener() {
        }

        public void onDirty() {
        }
    }
}

