/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IPartConverter;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableConfig;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;
import org.cyclops.integrateddynamics.item.ItemFacade;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class BlockCableConverter
implements IPartConverter {
    public Collection<Block> getConvertableBlocks() {
        return Collections.singleton(BlockCable.getInstance());
    }

    public Collection<? extends IMultipart> convertBlock(IBlockAccess world, BlockPos blockPos, boolean simulate) {
        IFacadeable facadeable;
        LinkedList parts = Lists.newLinkedList();
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileMultipartTicking.class);
        EnumFacingMap partData = EnumFacingMap.newMap(tile.getPartContainer().getPartData());
        EnumFacingMap forceDisconnected = EnumFacingMap.newMap(tile.getForceDisconnected());
        for (Map.Entry entry : partData.entrySet()) {
            parts.add(new PartPartType((EnumFacing)entry.getKey(), ((PartHelpers.PartStateHolder)entry.getValue()).getPart()));
        }
        boolean wasRealCable = tile.getCableFakeable().isRealCable();
        INetwork network = null;
        if (!simulate) {
            tile.getPartContainer().silentResetPartData();
            network = tile.getNetwork();
            tile.getNetworkCarrier().setNetwork(null);
            tile.getCableFakeable().setRealCable(false);
            BlockCable.IS_MCMP_CONVERTING = true;
        }
        if (wasRealCable) {
            PartCable partCable = new PartCable(partData, (EnumFacingMap<Boolean>)forceDisconnected);
            if (!simulate) {
                partCable.getNetworkCarrier().setNetwork(network);
            }
            partCable.setAddSilent(true);
            parts.add(partCable);
        }
        IFacadeable iFacadeable = facadeable = tile.hasCapability(FacadeableConfig.CAPABILITY, null) ? tile.getCapability(FacadeableConfig.CAPABILITY, null) : null;
        if (facadeable != null && !simulate && facadeable.hasFacade()) {
            IBlockState blockState = facadeable.getFacade();
            ItemStack itemStack = new ItemStack((Item)ItemFacade.getInstance());
            ItemFacade.getInstance().writeFacadeBlock(itemStack, blockState);
            ItemStackHelpers.spawnItemStack((World)tile.func_145831_w(), (BlockPos)blockPos, (ItemStack)itemStack);
        }
        return parts;
    }
}

