/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;
import org.cyclops.integrateddynamics.block.BlockCable;

public abstract class MultipartBase
extends Multipart
implements ISlottedPart,
INormallyOccludingPart,
INBTProvider {
    private final INBTProvider nbtProvider = new NBTProviderComponent((INBTProvider)this);
    private Map<Pair<Capability<?>, EnumFacing>, Object> capabilities = Maps.newHashMap();

    protected abstract ItemStack getItemStack();

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return this.getItemStack();
    }

    public List<ItemStack> getDrops() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getItemStack()});
    }

    public float getHardness(PartMOP hit) {
        return 3.0f;
    }

    public Material getMaterial() {
        return BlockCable.BLOCK_MATERIAL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(PartMOP partMOP, AdvancedParticleManager advancedParticleManager) {
        return true;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.nbtProvider.readGeneratedFieldsFromNBT(tag);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        this.nbtProvider.writeGeneratedFieldsToNBT(tag);
        return tag;
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        buf.func_150786_a(tag);
    }

    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        try {
            this.readFromNBT(buf.func_150793_b());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void markDirty() {
        super.markDirty();
    }

    public void sendUpdate() {
        this.sendUpdatePacket();
    }

    public void onAdded() {
        super.onAdded();
        if (this.capabilities instanceof HashMap) {
            this.capabilities = ImmutableMap.copyOf(this.capabilities);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.capabilities != null && this.capabilities.containsKey(Pair.of(capability, (Object)facing)) || facing != null && this.capabilities != null && this.capabilities.containsKey(Pair.of(capability, null)) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.capabilities != null) {
            Object value = this.capabilities.get(Pair.of(capability, (Object)facing));
            if (value == null && facing != null) {
                value = this.capabilities.get(Pair.of(capability, null));
            }
            if (value != null) {
                return (T)value;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public <T> void addCapabilityInternal(Capability<T> capability, T value) {
        this.capabilities.put(Pair.of(capability, null), value);
    }

    public <T> void addCapabilitySided(Capability<T> capability, EnumFacing facing, T value) {
        this.capabilities.put(Pair.of(capability, (Object)facing), value);
    }

    protected Map<Pair<Capability<?>, EnumFacing>, Object> getCapabilities() {
        return this.capabilities;
    }

    public void writeGeneratedFieldsToNBT(NBTTagCompound arg0) {
        this.nbtProvider.writeGeneratedFieldsToNBT(arg0);
    }

    public void readGeneratedFieldsFromNBT(NBTTagCompound arg0) {
        this.nbtProvider.readGeneratedFieldsFromNBT(arg0);
    }
}

