/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.block.property.ExtendedBlockStateBuilder;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IDynamicLight;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.block.BlockCableConfig;
import org.cyclops.integrateddynamics.capability.cable.CableConfig;
import org.cyclops.integrateddynamics.capability.cable.CablePartCable;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierConfig;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderPartContainer;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.PathElementPart;
import org.cyclops.integrateddynamics.client.model.CableRenderState;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.DynamicLightPart;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.DynamicRedstonePart;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.MultipartBase;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartContainerPartCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class PartCable
extends MultipartBase
implements ITickable {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected;
    @NBTPersist
    private int lightLevel = 0;
    @NBTPersist
    private int redstoneLevel = 0;
    @NBTPersist
    private boolean redstoneStrong = false;
    @NBTPersist
    private boolean allowsRedstone = false;
    private final PartContainerPartCable partContainer = new PartContainerPartCable(this);
    private final ICable cable;
    private final INetworkCarrier networkCarrier;
    private final EnumFacingMap<IDynamicLight> dynamicLights;
    private IBlockState cachedState = null;
    private boolean addSilent = false;
    private boolean sendFurtherUpdates = true;

    public PartCable() {
        this(EnumFacingMap.newMap(), (EnumFacingMap<Boolean>)EnumFacingMap.newMap());
    }

    public PartCable(EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> partData, EnumFacingMap<Boolean> forceDisconnected) {
        this.partContainer.setPartData((Map<EnumFacing, PartHelpers.PartStateHolder<?, ?>>)partData);
        this.addCapabilityInternal(PartContainerConfig.CAPABILITY, this.partContainer);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderPartContainer(this.partContainer));
        this.cable = new CablePartCable(this);
        this.addCapabilityInternal(CableConfig.CAPABILITY, this.cable);
        this.networkCarrier = new NetworkCarrierDefault();
        this.addCapabilityInternal(NetworkCarrierConfig.CAPABILITY, this.networkCarrier);
        this.addCapabilityInternal(PathElementConfig.CAPABILITY, new PathElementPart((IMultipart)this, this.cable));
        this.forceDisconnected = forceDisconnected;
        this.dynamicLights = EnumFacingMap.newMap();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            DynamicLightPart dynamicLight = new DynamicLightPart(this);
            this.dynamicLights.put((Enum)facing, (Object)dynamicLight);
            this.addCapabilitySided(DynamicLightConfig.CAPABILITY, facing, dynamicLight);
            this.addCapabilitySided(DynamicRedstoneConfig.CAPABILITY, facing, new DynamicRedstonePart(this));
        }
    }

    public EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> getPartData() {
        return this.partContainer.getPartData();
    }

    @Override
    protected ItemStack getItemStack() {
        return new ItemStack((Block)BlockCable.getInstance());
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.cachedState != null) {
            return this.cachedState;
        }
        ExtendedBlockStateBuilder builder = ExtendedBlockStateBuilder.builder((IExtendedBlockState)((IExtendedBlockState)state));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            builder.withProperty(BlockCable.CONNECTED[side.ordinal()], (Object)this.cable.isConnected(side));
            boolean hasPart = this.hasPart(side);
            if (hasPart) {
                builder.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)this.getPart(side).getPartRenderPosition());
            } else {
                builder.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)PartRenderPosition.NONE);
            }
            builder.withProperty(BlockCable.RENDERSTATE, (Object)new CableRenderState(true, (EnumFacingMap<Boolean>)EnumFacingMap.newMap(this.connected), EnumFacingMap.newMap(this.partContainer.getPartData()), null, 0));
        }
        this.cachedState = builder.build();
        return this.cachedState;
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], (IUnlistedProperty[])ArrayUtils.addAll((Object[])BlockCable.PART_RENDERPOSITIONS, (Object[])ArrayUtils.addAll((Object[])BlockCable.CONNECTED, (Object[])new IUnlistedProperty[]{BlockCable.RENDERSTATE})));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return BlockCable.getInstance().getCableBoundingBox(null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager advancedParticleManager) {
        advancedParticleManager.addBlockDestroyEffects(this.getPos(), BlockCable.getInstance().texture);
        return true;
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(BlockCable.getInstance().getCableBoundingBox(null));
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(BlockCable.getInstance().getCableBoundingBox(null));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.cable.isConnected(side)) {
                list.add(BlockCable.getInstance().getCableBoundingBox(side));
                continue;
            }
            if (!this.hasPart(side)) continue;
            list.add(this.getPart(side).getPartRenderPosition().getSidedCableBoundingBox(side));
        }
    }

    protected void addCollisionBoxConditional(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity, EnumFacing side) {
        AxisAlignedBB box = BlockCable.getInstance().getCableBoundingBox(side);
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    protected void addCollisionBoxWithPartConditional(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity, EnumFacing side) {
        AxisAlignedBB box = this.getPart(side).getPartRenderPosition().getSidedCableBoundingBox(side);
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    protected EnumFacing getSubHitSide(int subHit) {
        if (subHit == -1) {
            return null;
        }
        int i = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.cable.isConnected(side)) {
                if (i == subHit) {
                    return side;
                }
                ++i;
            }
            if (!this.hasPart(side)) continue;
            if (i == subHit) {
                return side;
            }
            ++i;
        }
        return null;
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        this.addCollisionBoxConditional(mask, list, collidingEntity, null);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.cable.isConnected(side)) {
                this.addCollisionBoxConditional(mask, list, collidingEntity, side);
                continue;
            }
            if (!this.hasPart(side)) continue;
            this.addCollisionBoxWithPartConditional(mask, list, collidingEntity, side);
        }
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation(IntegratedDynamics._instance.getModId(), BlockCableConfig._instance.getNamedId());
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.CENTER);
    }

    public void detectPresentParts() {
        IMultipartContainer container = this.getContainer();
        for (IMultipart multipart : container.getParts()) {
            if (!(multipart instanceof PartPartType)) continue;
            final PartPartType partPart = (PartPartType)multipart;
            PartHelpers.setPart(this.getNetwork(), this.getWorld(), this.getPos(), partPart.getFacing(), partPart.getPartType(), partPart.getPartType().getDefaultState(), new PartHelpers.IPartStateHolderCallback(){

                @Override
                public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                    PartCable.this.partContainer.getPartData().put((Enum)partPart.getFacing(), partStateHolder);
                    PartCable.this.sendUpdate();
                }
            });
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.isAddSilent()) {
            CableHelpers.onCableAdded(this.getWorld(), this.getPos(), null);
            this.detectPresentParts();
        }
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        CableHelpers.onCableRemoving(this.getWorld(), this.getPos(), false);
        super.harvest(player, hit);
    }

    public void onRemoved() {
        super.onRemoved();
        CableHelpers.onCableRemoved(this.getWorld(), this.getPos());
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        EnumFacing cableConnectionHit = this.getSubHitSide(hit.subHit);
        if (!this.getWorld().field_72995_K) {
            return CableHelpers.onCableActivated(this.getWorld(), this.getPos(), BlockCable.getInstance().func_176223_P(), player, player.func_184586_b(hand), hit.field_178784_b, cableConnectionHit);
        }
        return super.onActivated(player, hand, stack, hit);
    }

    public void onNeighborBlockChange(Block neighborBlock) {
        super.onNeighborBlockChange(neighborBlock);
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        this.cable.updateConnections();
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        tag.func_74782_a("partContainer", (NBTBase)this.partContainer.serializeNBT());
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_150297_b("parts", MinecraftHelpers.NBTTag_Types.NBTTagList.ordinal()) && !tag.func_150297_b("partContainer", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal())) {
            PartHelpers.readPartsFromNBT(this.getNetwork(), this.getPos(), tag, this.partContainer.getPartData(), this.getWorld());
        } else {
            this.partContainer.deserializeNBT(tag.func_74775_l("partContainer"));
        }
        super.readFromNBT(tag);
        this.cachedState = null;
    }

    protected INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    protected boolean hasPart(EnumFacing side) {
        return this.partContainer.hasPart(side);
    }

    protected IPartType getPart(EnumFacing side) {
        return this.partContainer.getPart(side);
    }

    public void onPartChanged(IMultipart part) {
        super.onPartChanged(part);
        if (this.sendFurtherUpdates) {
            this.cable.updateConnections();
        }
    }

    public void func_73660_a() {
        if (this.connected.isEmpty()) {
            this.cable.updateConnections();
        }
        this.partContainer.update();
    }

    public void setAddSilent(boolean addSilent) {
        this.addSilent = addSilent;
    }

    public boolean isAddSilent() {
        return this.addSilent;
    }

    public void setSendFurtherUpdates(boolean sendFurtherUpdates) {
        this.sendFurtherUpdates = sendFurtherUpdates;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) || this.partContainer.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T value = super.getCapability(capability, facing);
        if (value != null) {
            return value;
        }
        return this.partContainer.getCapability(capability, facing);
    }

    public int getLightValue() {
        int light = 0;
        for (EnumFacing side : EnumFacing.values()) {
            IDynamicLight dynamicLight = (IDynamicLight)this.dynamicLights.get((Object)side);
            if (dynamicLight == null) continue;
            light = Math.max(light, dynamicLight.getLightLevel());
        }
        return light;
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    public void setRedstoneLevel(int redstoneLevel) {
        this.redstoneLevel = redstoneLevel;
    }

    public boolean isRedstoneStrong() {
        return this.redstoneStrong;
    }

    public void setRedstoneStrong(boolean redstoneStrong) {
        this.redstoneStrong = redstoneStrong;
    }

    public boolean isAllowsRedstone() {
        return this.allowsRedstone;
    }

    public void setAllowsRedstone(boolean allowsRedstone) {
        this.allowsRedstone = allowsRedstone;
    }

    public PartContainerPartCable getPartContainer() {
        return this.partContainer;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }
}

