/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.refinedstorage.aspect;

import java.util.AbstractList;
import java.util.List;

public class LazyCompositeList<V>
extends AbstractList<V> {
    private final List<List<V>> inputs;

    public LazyCompositeList(List<List<V>> inputs) {
        this.inputs = inputs;
    }

    @Override
    public V get(int index) {
        int itIndex = index;
        for (List<V> input : this.inputs) {
            int size = input.size();
            if (itIndex < size) {
                return input.get(itIndex);
            }
            itIndex -= size;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int size = 0;
        for (List<V> input : this.inputs) {
            size += input.size();
        }
        return size;
    }
}

