/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.tesla;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.TileHelpers;

public class EnergyStorageTesla
implements IEnergyStorage {
    private final IBlockAccess world;
    private final BlockPos pos;
    private final EnumFacing facing;
    private ITeslaHolder energyStorage = null;
    private ITeslaConsumer energyReceiver = null;
    private ITeslaProducer energyProvider = null;

    public EnergyStorageTesla(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        this.world = world;
        this.pos = pos;
        this.facing = facing;
    }

    protected ITeslaHolder getEnergyStorage() {
        if (this.energyStorage != null) {
            return this.energyStorage;
        }
        this.energyStorage = (ITeslaHolder)TileHelpers.getCapability((IBlockAccess)this.world, (BlockPos)this.pos, (EnumFacing)this.facing, (Capability)TeslaCapabilities.CAPABILITY_HOLDER);
        return this.energyStorage;
    }

    protected ITeslaConsumer getEnergyReceiver() {
        if (this.energyReceiver != null) {
            return this.energyReceiver;
        }
        this.energyReceiver = (ITeslaConsumer)TileHelpers.getCapability((IBlockAccess)this.world, (BlockPos)this.pos, (EnumFacing)this.facing, (Capability)TeslaCapabilities.CAPABILITY_CONSUMER);
        return this.energyReceiver;
    }

    protected ITeslaProducer getEnergyProvider() {
        if (this.energyProvider != null) {
            return this.energyProvider;
        }
        this.energyProvider = (ITeslaProducer)TileHelpers.getCapability((IBlockAccess)this.world, (BlockPos)this.pos, (EnumFacing)this.facing, (Capability)TeslaCapabilities.CAPABILITY_PRODUCER);
        return this.energyProvider;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        ITeslaConsumer energyReceiver = this.getEnergyReceiver();
        return energyReceiver != null ? (int)energyReceiver.givePower((long)maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        ITeslaProducer energyProvider = this.getEnergyProvider();
        return energyProvider != null ? (int)energyProvider.takePower((long)maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        ITeslaHolder energyStorage = this.getEnergyStorage();
        return energyStorage != null ? (int)Math.min(Integer.MAX_VALUE, energyStorage.getStoredPower()) : 0;
    }

    public int getMaxEnergyStored() {
        ITeslaHolder energyStorage = this.getEnergyStorage();
        return energyStorage != null ? (int)Math.min(Integer.MAX_VALUE, energyStorage.getCapacity()) : 0;
    }

    public boolean canExtract() {
        return this.getEnergyProvider() != null;
    }

    public boolean canReceive() {
        return this.getEnergyReceiver() != null;
    }
}

