/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.capability.variablefacade.VariableFacadeHolderConfig;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integrateddynamics.item.ItemVariable;
import org.cyclops.integrateddynamics.network.VariablestoreNetworkElement;

public class TileVariablestore
extends TileCableConnectableInventory
implements IDirtyMarkListener {
    public static final int ROWS = 5;
    public static final int COLS = 9;
    private final IVariableContainer variableContainer;
    private boolean shouldSendUpdateEvent = false;

    public TileVariablestore() {
        super(45, "variables", 1);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        ArrayList slots = Lists.newArrayListWithCapacity((int)this.getInventory().func_70302_i_());
        for (int i = 0; i < this.getInventory().func_70302_i_(); ++i) {
            slots.add(i);
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addSlotsToSide(side, slots);
        }
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new VariablestoreNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.variableContainer = new VariableContainerDefault();
        this.addCapabilityInternal(VariableContainerConfig.CAPABILITY, this.variableContainer);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return super.func_94041_b(index, stack) && (stack == null || stack.hasCapability(VariableFacadeHolderConfig.CAPABILITY, null));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.refreshVariables((IInventory)this.inventory);
    }

    protected void refreshVariables(IInventory inventory) {
        this.variableContainer.getVariableCache().clear();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            IVariableFacade variableFacade;
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || (variableFacade = ItemVariable.getInstance().getVariableFacade(itemStack)) == null || !variableFacade.isValid()) continue;
            this.variableContainer.getVariableCache().put(variableFacade.getId(), variableFacade);
        }
        INetwork network = this.getNetwork();
        if (network != null) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }

    public void onDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.refreshVariables((IInventory)this.inventory);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldSendUpdateEvent = true;
        }
    }

    @Override
    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.shouldSendUpdateEvent && this.getNetwork() != null) {
            this.shouldSendUpdateEvent = false;
            this.refreshVariables((IInventory)this.inventory);
        }
    }
}

