/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.command.CommandDebug;
import org.cyclops.cyclopscore.command.CommandIgnite;
import org.cyclops.cyclopscore.command.CommandMod;
import org.cyclops.cyclopscore.command.CommandRecursion;
import org.cyclops.cyclopscore.command.CommandReloadResources;
import org.cyclops.cyclopscore.config.ConfigHandler;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.versionchecker.VersionCheckerModCompat;
import org.cyclops.cyclopscore.modcompat.waila.WailaModCompat;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.IModVersion;
import org.cyclops.cyclopscore.tracking.Versions;

@Mod(modid="cyclopscore", name="Cyclops Core", useMetadata=true, version="0.10.9", dependencies="required-after:forge@[13.20.0.2282,);", guiFactory="org.cyclops.cyclopscore.GuiConfigOverview$ExtendedConfigGuiFactory", acceptedMinecraftVersions="[1.11.2]")
public class CyclopsCore
extends ModBase
implements IModVersion {
    @SidedProxy(clientSide="org.cyclops.cyclopscore.proxy.ClientProxy", serverSide="org.cyclops.cyclopscore.proxy.CommonProxy")
    public static ICommonProxy proxy;
    @Mod.Instance(value="cyclopscore")
    public static CyclopsCore _instance;
    private boolean versionInfo = false;
    private String version;
    private String info;
    private String updateUrl;

    public CyclopsCore() {
        super("cyclopscore", "Cyclops Core");
        this.putGenericReference(REFKEY_MOD_VERSION, "0.10.9");
        FluidRegistry.enableUniversalBucket();
    }

    @Override
    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        modCompatLoader.addModCompat(new VersionCheckerModCompat());
        modCompatLoader.addModCompat(new WailaModCompat());
    }

    @Override
    protected RecipeHandler constructRecipeHandler() {
        return null;
    }

    @Override
    protected ICommand constructBaseCommand() {
        HashMap commands = Maps.newHashMap();
        commands.put("recursion", new CommandRecursion(this));
        commands.put("ignite", new CommandIgnite(this));
        commands.put("debug", new CommandDebug(this));
        commands.put("reloadresources", new CommandReloadResources(this));
        CommandMod command = new CommandMod((ModBase)this, commands);
        command.addAlias("cyclops");
        return command;
    }

    @Override
    @Mod.EventHandler
    public final void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    @Mod.EventHandler
    public final void init(FMLInitializationEvent event) {
        Analytics.sendAll();
        Versions.checkAll();
        super.init(event);
    }

    @Override
    @Mod.EventHandler
    public final void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        super.onServerStarting(event);
    }

    @Override
    public CreativeTabs constructDefaultCreativeTab() {
        return null;
    }

    @Override
    public ICommonProxy getProxy() {
        return proxy;
    }

    @Override
    public void onGeneralConfigsRegister(ConfigHandler configHandler) {
        configHandler.add(new GeneralConfig());
    }

    @Override
    public void onMainConfigsRegister(ConfigHandler configHandler) {
        super.onMainConfigsRegister(configHandler);
        configHandler.add(new FluidHandlerItemCapacityConfig());
    }

    public static void clog(String message) {
        _instance.log(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.log(level, message);
    }

    @Override
    public void setVersionInfo(String version, String info, String updateUrl) {
        this.versionInfo = true;
        this.version = version;
        this.info = info;
        this.updateUrl = updateUrl;
    }

    @Override
    public boolean isVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getUpdateUrl() {
        return this.updateUrl;
    }

    @Override
    public boolean needsUpdate() {
        return this.getVersion() != null && !"0.10.9".equals(this.getVersion());
    }
}

