/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockPropertyManagerComponent;
import org.cyclops.cyclopscore.block.property.IBlockPropertyManager;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurable.IConfigurableBlock;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

public class ConfigurableBlock
extends Block
implements IConfigurableBlock,
IDynamicModelElement {
    protected IBlockPropertyManager propertyManager;
    protected BlockConfig eConfig = null;
    protected boolean hasGui = false;
    protected int pass = 0;
    protected boolean isInventoryBlock = false;

    protected BlockStateContainer func_180661_e() {
        this.propertyManager = new BlockPropertyManagerComponent(this);
        return this.propertyManager.createDelegatedBlockState();
    }

    public ConfigurableBlock(ExtendedConfig eConfig, Material material) {
        super(material);
        this.setConfig(eConfig);
        this.func_149663_c(eConfig.getUnlocalizedName());
        if (MinecraftHelpers.isClientSide() && this.hasDynamicModel()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public boolean hasGui() {
        return this.hasGui;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColorHandler() {
        return null;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState blockState = super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        for (IProperty property : blockState.func_177227_a()) {
            if (!property.func_177701_a().equals("facing")) continue;
            blockState.func_177226_a(property, (Comparable)placer.func_174811_aO());
        }
        return blockState;
    }

    private void setConfig(ExtendedConfig eConfig) {
        this.eConfig = (BlockConfig)eConfig;
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return this.eConfig;
    }

    @Override
    public boolean hasDynamicModel() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        if (this.hasDynamicModel()) {
            IBakedModel cableModel = this.createDynamicModel();
            event.getModelRegistry().func_82595_a((Object)this.eConfig.dynamicBlockVariantLocation, (Object)cableModel);
            event.getModelRegistry().func_82595_a((Object)this.eConfig.dynamicItemVariantLocation, (Object)cableModel);
        }
    }

    public int func_176201_c(IBlockState state) {
        return this.propertyManager.getMetaFromState(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.propertyManager.getStateFromMeta(meta);
    }

    public BlockStateContainer createDelegatedBlockState() {
        return this.propertyManager.createDelegatedBlockState();
    }
}

