/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.config.configurable.IConfigurableItem;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public class ItemAction
extends ConfigurableTypeAction<ItemConfig> {
    public static void register(Item item, ExtendedConfig config, @Nullable CreativeTabs creativeTabs) {
        ItemAction.register(item, config);
        if (creativeTabs != null) {
            item.func_77637_a(creativeTabs);
        }
    }

    @Override
    public void preRun(ItemConfig eConfig, Configuration config, boolean startup) {
        Property property = config.get(eConfig.getHolderType().getCategory(), eConfig.getNamedId(), eConfig.isEnabled());
        property.setRequiresMcRestart(true);
        property.setComment(eConfig.getComment());
        property.setLanguageKey(eConfig.getFullUnlocalizedName());
        if (startup) {
            eConfig.setEnabled(property.getBoolean(true));
        }
    }

    @Override
    public void postRun(ItemConfig eConfig, Configuration config) {
        eConfig.save();
        Item item = (Item)eConfig.getSubInstance();
        ItemAction.register(item, eConfig, eConfig.getTargetTab());
        if (item instanceof IGuiContainerProvider) {
            IGuiContainerProvider gui = (IGuiContainerProvider)item;
            eConfig.getMod().getGuiHandler().registerGUI(gui, GuiHandler.GuiType.ITEM);
        }
    }

    public static void handleItemModel(Item item, String namedId, CreativeTabs tab, String modId, IModelProviderConfig modelProvider) {
        if (MinecraftHelpers.isClientSide()) {
            if (item.func_77614_k()) {
                NonNullList itemStacks = NonNullList.func_191196_a();
                item.func_150895_a(item, tab, itemStacks);
                for (ItemStack itemStack : itemStacks) {
                    String itemName = modelProvider.getModelName(itemStack);
                    ModelResourceLocation model = new ModelResourceLocation(modId + ":" + itemName, "inventory");
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{model});
                    Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, itemStack.func_77960_j(), model);
                }
            } else {
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, new ModelResourceLocation(modId + ":" + namedId, "inventory"));
            }
        }
    }

    @Override
    public void polish(ItemConfig config) {
        if (MinecraftHelpers.isClientSide()) {
            IConfigurableItem configurableItem;
            IItemColor itemColorHandler;
            Item item = config.getItemInstance();
            ItemAction.handleItemModel(item, config.getNamedId(), config.getTargetTab(), config.getMod().getModId(), config);
            if (item instanceof IConfigurableItem && (itemColorHandler = (configurableItem = (IConfigurableItem)item).getItemColorHandler()) != null) {
                Minecraft.func_71410_x().getItemColors().func_186730_a(itemColorHandler, new Item[]{item});
            }
        }
    }
}

