/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class DamageIndicatedItemComponent {
    public ItemFluidContainer item;

    public DamageIndicatedItemComponent(ItemFluidContainer item) {
        this.item = item;
        item.func_77625_d(1);
    }

    public void getSubItems(Item item, CreativeTabs tab, NonNullList<ItemStack> itemList, Fluid fluid, int meta) {
        ItemStack itemStackFull = new ItemStack((Item)this.item, 1, meta);
        IFluidHandlerItemCapacity fluidHanderFull = FluidHelpers.getFluidHandlerItemCapacity(itemStackFull);
        fluidHanderFull.fill(new FluidStack(fluid, fluidHanderFull.getCapacity()), true);
        itemList.add((Object)itemStackFull);
        ItemStack itemStackEmpty = new ItemStack(item, 1, meta);
        itemList.add((Object)itemStackEmpty);
    }

    public String getInfo(ItemStack itemStack) {
        int amount = 0;
        IFluidHandlerItemCapacity fluidHander = FluidHelpers.getFluidHandlerItemCapacity(itemStack);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        if (fluidStack != null) {
            amount = fluidStack.amount;
        }
        return DamageIndicatedItemComponent.getInfo(fluidStack, amount, fluidHander.getCapacity());
    }

    public static String getInfo(FluidStack fluidStack, int amount, int capacity) {
        String prefix = "";
        if (fluidStack != null) {
            prefix = fluidStack.getFluid().getLocalizedName(fluidStack) + ": ";
        }
        return prefix + String.format("%,d", amount) + " / " + String.format("%,d", capacity) + " mB";
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        list.add(IInformationProvider.ITEM_PREFIX + ((IInformationProvider)itemStack.func_77973_b()).getInfo(itemStack));
    }

    public double getDurability(ItemStack itemStack) {
        IFluidHandlerItemCapacity fluidHander = FluidHelpers.getFluidHandlerItemCapacity(itemStack);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        double capacity = fluidHander.getCapacity();
        double amount = FluidHelpers.getAmount(fluidStack);
        return (capacity - amount) / capacity;
    }
}

