/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.ClassUtils;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;

public abstract class PacketCodec
extends PacketBase {
    private static Map<Class<?>, ICodecAction> codecActions = Maps.newHashMap();
    protected SingleCache<Void, List<Field>> fieldCache = new SingleCache<Void, List<Field>>(new SingleCache.ICacheUpdater<Void, List<Field>>(){

        @Override
        public List<Field> getNewValue(Void key) {
            LinkedList fieldList = Lists.newLinkedList();
            for (Class<?> clazz = PacketCodec.this.getClass(); clazz != PacketCodec.class && clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                Arrays.sort(fields, new Comparator<Field>(){

                    @Override
                    public int compare(Field o1, Field o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(CodecField.class)) continue;
                    fieldList.add(field);
                }
            }
            return fieldList;
        }

        @Override
        public boolean isKeyEqual(Void cacheKey, Void newKey) {
            return true;
        }
    });

    protected static ICodecAction getAction(Class<?> clazz) {
        ICodecAction action;
        if (ClassUtils.isPrimitiveWrapper(clazz)) {
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        if ((action = codecActions.get(clazz)) == null) {
            System.err.println("No ICodecAction was found for " + clazz + ". You should add one in PacketCodec.");
        }
        return action;
    }

    private void loopCodecFields(ICodecRunnable runnable) {
        try {
            for (Field field : this.fieldCache.get(null)) {
                Class<?> clazz = field.getType();
                ICodecAction action = PacketCodec.getAction(clazz);
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                runnable.run(field, action);
                field.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void encode(final ByteArrayDataOutput output) {
        this.loopCodecFields(new ICodecRunnable(){

            @Override
            public void run(Field field, ICodecAction action) {
                Object object = null;
                try {
                    object = field.get(PacketCodec.this);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                action.encode(object, output);
            }
        });
    }

    @Override
    public void decode(final ByteArrayDataInput input) {
        this.loopCodecFields(new ICodecRunnable(){

            @Override
            public void run(Field field, ICodecAction action) {
                Object object = action.decode(input);
                try {
                    field.set(PacketCodec.this, object);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        codecActions.put(String.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeUTF((String)object);
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readUTF();
            }
        });
        codecActions.put(Double.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeDouble(((Double)object).doubleValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readDouble();
            }
        });
        codecActions.put(Integer.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeInt(((Integer)object).intValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readInt();
            }
        });
        codecActions.put(Short.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeShort((int)((Short)object).shortValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readShort();
            }
        });
        codecActions.put(Boolean.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeBoolean(((Boolean)object).booleanValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readBoolean();
            }
        });
        codecActions.put(Float.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeFloat(((Float)object).floatValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return Float.valueOf(input.readFloat());
            }
        });
        codecActions.put(Vec3d.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                Vec3d v = (Vec3d)object;
                output.writeDouble(v.field_72450_a);
                output.writeDouble(v.field_72448_b);
                output.writeDouble(v.field_72449_c);
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                double x = input.readDouble();
                double y = input.readDouble();
                double z = input.readDouble();
                return new Vec3d(x, y, z);
            }
        });
        codecActions.put(Map.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                Map map = (Map)object;
                output.writeInt(map.size());
                Set entries = map.entrySet();
                ICodecAction keyAction = null;
                ICodecAction valueAction = null;
                for (Map.Entry entry : entries) {
                    if (keyAction == null) {
                        keyAction = PacketCodec.getAction(entry.getKey().getClass());
                        output.writeUTF(entry.getKey().getClass().getName());
                    }
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(entry.getValue().getClass());
                        output.writeUTF(entry.getValue().getClass().getName());
                    }
                    keyAction.encode(entry.getKey(), output);
                    valueAction.encode(entry.getValue(), output);
                }
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                HashMap map = Maps.newHashMap();
                int size = input.readInt();
                if (size == 0) {
                    return map;
                }
                try {
                    ICodecAction keyAction = PacketCodec.getAction(Class.forName(input.readUTF()));
                    ICodecAction valueAction = PacketCodec.getAction(Class.forName(input.readUTF()));
                    for (int i = 0; i < size; ++i) {
                        Object key = keyAction.decode(input);
                        Object value = valueAction.decode(input);
                        map.put(key, value);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return map;
            }
        });
        codecActions.put(NBTTagCompound.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                try {
                    CompressedStreamTools.func_74800_a((NBTTagCompound)((NBTTagCompound)object), (DataOutput)output);
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                try {
                    return CompressedStreamTools.func_152456_a((DataInput)input, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }
        });
        codecActions.put(ItemStack.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                try {
                    output.writeBoolean(object != null);
                    if (object != null) {
                        NBTTagCompound tag = new NBTTagCompound();
                        ((ItemStack)object).func_77955_b(tag);
                        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
                    }
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                try {
                    if (input.readBoolean()) {
                        NBTTagCompound tag = CompressedStreamTools.func_152456_a((DataInput)input, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
                        return new ItemStack(tag);
                    }
                    return null;
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }
        });
        codecActions.put(List.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                List list = (List)object;
                output.writeInt(list.size());
                if (list.size() == 0) {
                    return;
                }
                ICodecAction valueAction = null;
                for (int i = 0; i < list.size(); ++i) {
                    Object value = list.get(i);
                    if (value == null) continue;
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(value.getClass());
                        output.writeUTF(value.getClass().getName());
                    }
                    output.writeInt(i);
                    valueAction.encode(value, output);
                }
                if (valueAction == null) {
                    output.writeUTF("__noclass");
                } else {
                    output.writeInt(-1);
                }
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                int size = input.readInt();
                if (size == 0) {
                    return Collections.emptyList();
                }
                ArrayList list = Lists.newArrayListWithExpectedSize((int)size);
                try {
                    String className = input.readUTF();
                    if (!className.equals("__noclass")) {
                        int i;
                        ICodecAction valueAction = PacketCodec.getAction(Class.forName(className));
                        int currentLength = 0;
                        while ((i = input.readInt()) >= 0) {
                            while (currentLength < i) {
                                list.add(null);
                                ++currentLength;
                            }
                            Object value = valueAction.decode(input);
                            list.add(value);
                            ++currentLength;
                        }
                        while (currentLength < size) {
                            list.add(null);
                            ++currentLength;
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            list.add(null);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return list;
            }
        });
    }

    private static interface ICodecRunnable {
        public void run(Field var1, ICodecAction var2);
    }

    private static interface ICodecAction {
        public void encode(Object var1, ByteArrayDataOutput var2);

        public Object decode(ByteArrayDataInput var1);
    }
}

