/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tracking;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;

public class Analytics {
    private static final String REQUEST_PATTERN = "http://www.google-analytics.com/collect?v=1&tid=%s&cid=%s&t=screenview&cd=Startup&an=%s&av=%s&cd1=%s&cd2=%s&cd3=%s";
    private static boolean checked = false;
    private static final List<Pair<ModBase, String>> trackingMods = Lists.newLinkedList();

    public static synchronized void registerMod(ModBase mod, String trackingId) {
        trackingMods.add((Pair<ModBase, String>)Pair.of((Object)mod, (Object)trackingId));
    }

    protected static synchronized List<Pair<ModBase, String>> getTrackingMods() {
        return Lists.newArrayList(trackingMods);
    }

    public static void sendAll() {
        if (!checked) {
            checked = true;
            if (MinecraftHelpers.isClientSide() ? Minecraft.func_71410_x().func_70002_Q() : FMLCommonHandler.instance().getMinecraftServerInstance().func_70002_Q()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        List<Pair<ModBase, String>> trackingMods = Analytics.getTrackingMods();
                        for (Pair<ModBase, String> pair : trackingMods) {
                            try {
                                URL url = new URL(Analytics.createRequestURL((ModBase)pair.getLeft(), (String)pair.getRight()));
                                IOUtils.toString((URL)url);
                            }
                            catch (IOException e) {
                                ((ModBase)pair.getLeft()).log(Level.WARN, "Could not send tracking info: " + e.toString());
                            }
                        }
                    }
                }).start();
            }
        }
    }

    protected static String createRequestURL(ModBase mod, String trackingId) throws UnsupportedEncodingException {
        String mcVersion = URLEncoder.encode("1.11.2", "UTF-8");
        return String.format(REQUEST_PATTERN, trackingId, GeneralConfig.anonymousAnalyticsID, URLEncoder.encode(mod.getModName(), "UTF-8"), mcVersion + "-" + URLEncoder.encode(mod.getReferenceValue(ModBase.REFKEY_MOD_VERSION), "UTF-8"), mcVersion, MinecraftHelpers.isClientSide() ? "client" : "server", System.getProperty("java.version"));
    }
}

