/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part.aspect;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;

public interface IAspect<V extends IValue, T extends IValueType<V>> {
    public String getUnlocalizedName();

    public void loadTooltip(List<String> var1, boolean var2);

    public T getValueType();

    public <P extends IPartType<P, S>, S extends IPartState<P>> void update(IPartNetwork var1, P var2, PartTarget var3, S var4);

    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean hasProperties();

    public <P extends IPartType<P, S>, S extends IPartState<P>> IAspectProperties getProperties(P var1, PartTarget var2, S var3);

    public <P extends IPartType<P, S>, S extends IPartState<P>> void setProperties(P var1, PartTarget var2, S var3, IAspectProperties var4);

    public IAspectProperties getDefaultProperties();

    public Collection<IAspectPropertyTypeInstance> getPropertyTypes();

    public IGuiContainerProvider getPropertiesGuiProvider();

    public static class AspectComparator
    implements Comparator<IAspect> {
        private static AspectComparator INSTANCE = null;

        private AspectComparator() {
        }

        public static AspectComparator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new AspectComparator();
            }
            return INSTANCE;
        }

        @Override
        public int compare(IAspect o1, IAspect o2) {
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    }
}

